/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="17.1.28")
@CheckID(value="SVTB.10.18")
@CheckName(value="SVTB.10.18")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.PREDEFINED_METHOD, RuleLabel.FORMAT_SPECIFIER})
@CheckTitle(value="Do not use object handles with %p")
@CheckDescription(value="Do not use %p with an object handle as this will print out all the information of that object in one line.\n\nExamples:\n\nclass A;\n\tint field;\nendclass;\n\nclass B;\n\tfunction void foo()\n\t\t$display(\"%p\", A); // allowed\n\t\t$display(\"%p\", this); // not allowed\n\tendfunction\nendclass;\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_18
extends OVMComplianceCheck {
    public Check_SVTB_10_18(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            protected ParserPath parserPath;

            public boolean visit(IHidObject hidObject) {
                if (Check_SVTB_10_18.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (hidObject.getHidKind() != IHidObject.HidKind.HID) {
                    return true;
                }
                if (!(hidObject instanceof RfHid)) {
                    return true;
                }
                RfHid hid = (RfHid)hidObject;
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (!LintUtilsConstants.PRINT_TASKS.contains(methodCall.getMethodName())) continue;
                    Check_SVTB_10_18.this.notifyCheckAlive();
                    if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) continue;
                    String specifiers = null;
                    Map argumentValuesMapRaw = methodCall.argumentValuesMapRaw;
                    for (Map.Entry argumentValue : argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                        IHidObject value = (IHidObject)argumentValue.getValue();
                        if (!(key instanceof RfPredefinedField) || !(value instanceof RfHidImplicit)) continue;
                        specifiers = ((RfHidImplicit)value).getName();
                        break;
                    }
                    if (specifiers == null) continue;
                    List<Specifier> listOfSpecifiers = this.createListOfSpecifiers(specifiers);
                    int indexInSpecifiers = 0;
                    for (Map.Entry argumentValue : argumentValuesMapRaw.entrySet()) {
                        RfHid rfHid;
                        IRfNamedElement element;
                        IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                        IHidObject value = (IHidObject)argumentValue.getValue();
                        if (!(key instanceof RfField) || !(value instanceof RfHid) || !((element = (rfHid = (RfHid)value).getElement()) instanceof RfField) || indexInSpecifiers >= listOfSpecifiers.size()) continue;
                        Specifier specifier = listOfSpecifiers.get(indexInSpecifiers);
                        if ((specifier.element.equals("p") || specifier.element.equals("P")) && element instanceof RfAssociatedType && LintUtils.getAssociatedFinalType((RfAssociatedType)element) instanceof RfClass) {
                            Check_SVTB_10_18.this.addHit(this.parserPath, methodCall.occurrence, "Object handler '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "' is used as argument for " + specifiers.substring(specifier.startIndex, specifier.endIndex + 1) + " format specifier!");
                        }
                        ++indexInSpecifiers;
                    }
                }
                return true;
            }

            private List<Specifier> createListOfSpecifiers(String specifiers) {
                ArrayList<Specifier> listOfSpecifiers = new ArrayList<Specifier>();
                int numberOfPercents = 0;
                int i = 0;
                while (i < specifiers.length()) {
                    int start = i;
                    while (i < specifiers.length() && (specifiers.charAt(i) == '%' || specifiers.charAt(i) == '0')) {
                        if (specifiers.charAt(i) == '%') {
                            ++numberOfPercents;
                        }
                        ++i;
                    }
                    int end = i;
                    if (numberOfPercents % 2 == 0) {
                        numberOfPercents = 0;
                    } else {
                        Specifier specifier = new Specifier(start, end, String.valueOf(specifiers.charAt(i)));
                        listOfSpecifiers.add(specifier);
                        numberOfPercents = 0;
                    }
                    ++i;
                }
                return listOfSpecifiers;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }

            class Specifier {
                int startIndex;
                int endIndex;
                String element;

                Specifier(int startIndex, int endIndex, String element) {
                    this.startIndex = startIndex;
                    this.endIndex = endIndex;
                    this.element = element;
                }
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

