/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.43")
@CheckID(value="SVTB.10.19")
@CheckName(value="SVTB.10.19")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.METHOD, RuleLabel.FORMAT_SPECIFIER})
@CheckTitle(value="Specify radix before any binary, decimal, octal or hex format specifiers")
@CheckDescription(value="Specify radix before any binary, decimal, octal or hex format specifiers.\n$display(\"%0h\", hex_value); \t// NOT ALLOWED\n$display(\"'h%0h\", hex_value); \t// ALLOWED\n$display(\"'sh%0h\", hex_value); \t// ALLOWED\n\nImplementation Notes:\n$sformatf is checked only if the variable holding its result is directly used in one of the other methods specified in the <checkMethods> parameter or in UVM report macros.\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_19
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="binary, decimal, octal, hex", description="Comma separated list of radixes to check.", name="checkRadixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckRadixes;
    @CheckParameter(defaultValue="$display, $displayb, $displayo, $displayh, $write, $writeb, $writeo, $writeh, $strobe, $strobeb, $strobeo, $strobeh, $monitor, $monitorb, $monitoro, $monitorh, $fdisplay, $fdisplayb, $fdisplayo, $fdisplayh, $fmonitor, $fmonitorb, $fmonitoro, $fmonitorh, $fwrite, $fwriteb, $fwriteo, $fwriteh, $fstrobe, $fstrobeb, $fstrobeo, $fstrobeh, $swrite, $swriteb, $swriteo, $swriteh, $sformatf, $sformat, $psprintf", description="Comma separated list of methods to check.", name="checkMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckMethods;
    @CheckParameter(defaultValue="true", description="When true, the check will fail if any prefix appears for decimal format specifiers.", name="noDecimalPrefix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pExcludeDecimals;
    @CheckParameter(defaultValue="false", description="When true, the check will allow any prefix without a tick.", name="allowNoTickBeforeRadix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowNoTickBeforeRadix;
    private static final HashSet<String> UVM_DISPLAY_FUNCTIONS = new HashSet<String>(Arrays.asList("uvm_report_info", "uvm_report_warning", "uvm_report_error", "uvm_report_fatal"));

    public Check_SVTB_10_19(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pCheckRadixes.isEmpty()) {
            return;
        }
        StringBuilder radixPrefixRegex = new StringBuilder();
        int i = 0;
        for (String radix : this.pCheckRadixes) {
            if (radix.equals("binary")) {
                if (i > 0) {
                    radixPrefixRegex.append("|");
                }
                radixPrefixRegex.append("((?<!" + (this.pAllowNoTickBeforeRadix ? "" : "'") + "[s|S]?[bB]\\s?|%" + ")%[0-9]*(\\.)?[0-9]*[bB])");
            } else if (radix.equals("decimal") && !this.pExcludeDecimals) {
                if (i > 0) {
                    radixPrefixRegex.append("|");
                }
                radixPrefixRegex.append("((?<!" + (this.pAllowNoTickBeforeRadix ? "" : "'") + "[s|S]?[dD]\\s?|%" + ")%[0-9]*(\\.)?[0-9]*[dD])");
            } else if (radix.equals("octal")) {
                if (i > 0) {
                    radixPrefixRegex.append("|");
                }
                radixPrefixRegex.append("((?<!" + (this.pAllowNoTickBeforeRadix ? "" : "'") + "[s|S]?[oO]\\s?|%" + ")%[0-9]*(\\.)?[0-9]*[oO])");
            } else if (radix.equals("hex")) {
                if (i > 0) {
                    radixPrefixRegex.append("|");
                }
                radixPrefixRegex.append("((?<!" + (this.pAllowNoTickBeforeRadix ? "" : "'") + "[s|S]?[hHxX]\\s?|%" + ")%[0-9]*(\\.)?[0-9]*[hHxX])");
            }
            ++i;
        }
        Pattern radixPrefixPattern = Pattern.compile(radixPrefixRegex.toString());
        Pattern excludeDecimalsPattern = Pattern.compile("['|0][s|S]?[dD]%[0-9]*(\\.)?[0-9]*[dD]");
        RfProject rfProject = this.fOVMProject.getRfProject();
        IdentityHashMap<RfHid, RfField> $sformatfOutputVariables = new IdentityHashMap<RfHid, RfField>();
        rfProject.visitHidObject(rfProject, new ArgumentOperatorVisitor($sformatfOutputVariables, this));
        HashSet<RfField> $sformatfVariablesDisplayed = new HashSet<RfField>();
        rfProject.visitHidObject(rfProject, new CheckMethodsVisitor(radixPrefixPattern, $sformatfOutputVariables, excludeDecimalsPattern, $sformatfVariablesDisplayed, this));
        for (Map.Entry<RfHid, RfField> sformatfEntry : $sformatfOutputVariables.entrySet()) {
            List methodCalls;
            if (!$sformatfVariablesDisplayed.contains(sformatfEntry.getValue()) || (methodCalls = MethodCallUtils.getMethodCalls((IHid)((IHid)sformatfEntry.getKey()))) == null || methodCalls.isEmpty()) continue;
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject value = (IHidObject)entry.getValue();
                    if (!(value instanceof RfHidImplicit)) continue;
                    this.checkDisplayRadix(((RfHidImplicit)value).getName(), ((RfNamedElement)sformatfEntry.getValue()).getFile().getParserPath(), methodCall, radixPrefixPattern, excludeDecimalsPattern);
                }
            }
        }
    }

    protected void checkDisplayRadix(String formatString, ParserPath parserPath, MethodCall methodCall, Pattern radixPrefixPattern, Pattern excludeDecimalsPattern) {
        String arg;
        IHidObject value;
        Matcher m = radixPrefixPattern.matcher(formatString);
        StringBuilder sb = new StringBuilder();
        while (m.find() && !radixPrefixPattern.toString().isEmpty()) {
            sb.append(methodCall.method.getName()).append('(');
            for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                value = (IHidObject)entry.getValue();
                arg = "";
                if (value instanceof RfHidImplicit) {
                    arg = ((RfHidImplicit)value).getName();
                } else if (value instanceof RfHid) {
                    arg = ((RfHid)value).getName();
                } else if (value != null) {
                    arg = value.toString();
                }
                sb.append(arg).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(')');
            this.addHit(parserPath, methodCall.occurrence.getLine(), "Format specifier '" + m.group() + "' is not prefixed with the corresponding radix in '" + sb.toString() + "'!", null);
            sb.setLength(0);
        }
        if (this.pExcludeDecimals) {
            m = excludeDecimalsPattern.matcher(formatString);
            while (m.find()) {
                sb.append(methodCall.method.getName()).append('(');
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    value = (IHidObject)entry.getValue();
                    arg = "";
                    arg = value instanceof RfHidImplicit ? ((RfHidImplicit)value).getName() : (value instanceof RfHid ? ((RfHid)value).getName() : value.toString());
                    sb.append(arg).append(", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append(')');
                this.addHit(parserPath, methodCall.occurrence.getLine(), "Decimal format specifier '" + m.group().substring(m.group().lastIndexOf(37), m.group().length()) + "' is prefixed in '" + sb.toString() + "'!", null);
                sb.setLength(0);
            }
        }
    }

    private final class ArgumentOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private final IdentityHashMap<RfHid, RfField> $sformatfOutputVariables;
        ParserPath parserPath;
        private OVMComplianceCheck check;

        private ArgumentOperatorVisitor(IdentityHashMap<RfHid, RfField> $sformatfOutputVariables, OVMComplianceCheck check) {
            this.$sformatfOutputVariables = $sformatfOutputVariables;
            this.check = check;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (Check_SVTB_10_19.this.fOVMProject.getProjectWaivers().pathIsPrewaived(this.parserPath, this.check)) {
                return true;
            }
            if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE)) {
                return true;
            }
            Check_SVTB_10_19.this.notifyCheckAlive();
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject methodCall = (IHidObject)rhValues.get(0);
            if (methodCall instanceof RfHidAccessArgs) {
                methodCall = ((RfHidAccessArgs)methodCall).getParentHid();
            }
            if (!(methodCall instanceof RfHid)) {
                return true;
            }
            if (!(((RfHid)methodCall).getElement() instanceof RfPredefinedFunction)) {
                return true;
            }
            if (!((RfHid)methodCall).getName().equals("$sformatf")) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            IRfNamedElement element = ((RfHid)lhValue).getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            this.$sformatfOutputVariables.put((RfHid)methodCall, (RfField)element);
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private final class CheckMethodsVisitor
    extends RfHidVisitor {
        private final Pattern radixPrefixPattern;
        private final IdentityHashMap<RfHid, RfField> $sformatfOutputVariables;
        private final Pattern excludeDecimalsPattern;
        private final HashSet<RfField> $sformatfVariablesDisplayed;
        private OVMComplianceCheck check;

        private CheckMethodsVisitor(Pattern radixPrefixPattern, IdentityHashMap<RfHid, RfField> $sformatfOutputVariables, Pattern excludeDecimalsPattern, HashSet<RfField> $sformatfVariablesDisplayed, OVMComplianceCheck check) {
            this.radixPrefixPattern = radixPrefixPattern;
            this.$sformatfOutputVariables = $sformatfOutputVariables;
            this.excludeDecimalsPattern = excludeDecimalsPattern;
            this.$sformatfVariablesDisplayed = $sformatfVariablesDisplayed;
            this.check = check;
        }

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            if (Check_SVTB_10_19.this.fOVMProject.getProjectWaivers().pathIsPrewaived(this.parserPath, this.check)) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            Check_SVTB_10_19.this.notifyCheckAlive();
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return true;
            }
            if (element instanceof RfPredefinedFunction && this.$sformatfOutputVariables.containsKey((Object)hid)) {
                return true;
            }
            String methodName = element.getName();
            if (!Check_SVTB_10_19.this.pCheckMethods.contains(methodName) && !UVM_DISPLAY_FUNCTIONS.contains(methodName)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IRfNamedElement field;
                    IHidObject value = (IHidObject)entry.getValue();
                    if (value instanceof RfHidImplicit && !UVM_DISPLAY_FUNCTIONS.contains(methodName)) {
                        Check_SVTB_10_19.this.checkDisplayRadix(((RfHidImplicit)value).getName(), this.parserPath, methodCall, this.radixPrefixPattern, this.excludeDecimalsPattern);
                        continue;
                    }
                    if (!(value instanceof RfHid) || !((field = ((RfHid)value).getElement()) instanceof RfField) || !this.$sformatfOutputVariables.containsValue(field)) continue;
                    this.$sformatfVariablesDisplayed.add((RfField)field);
                }
            }
            return true;
        }
    }
}

