/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="20.1.34")
@CheckID(value="SVTB.10.1.1")
@CheckName(value="SVTB.10.1.1")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.MACRO, RuleLabel.PARENTHESIS})
@CheckTitle(value="Macros used in arithmetic expressions must be enclosed in parenthesis")
@CheckDescription(value="Macros containing arithmetic expressions must be enclosed in parenthesis when they are used or their value must contain surrounding parenthesis.\nThis will ensure that the intended order of operations is preserved when the macro is pre-processed and its value is replaced in the source file as it is.\nIf parenthesis are missing the order of operations might change the end result of the expression.\n\nExamples:\n\n`define op1 2 - 1\n\nclass my_class;\n\tinteger a;\n\n\tfunction void foo()\n\t\ta = 3 - `op1; // not allowed\n\t\ta = 4 - (3 - `op1); // not allowed\n\t\ta = 4 - 3 - (`op1); // allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_1_1
extends OVMComplianceCheck {
    public Check_SVTB_10_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalHidOperatorVisitor());
    }

    protected boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator operator) {
            if (operator.getOperatorText() == null) {
                return true;
            }
            if (operator.isHidden()) {
                return true;
            }
            if (!operator.isArithmetic()) {
                return true;
            }
            if (operator.getReparseInfo() == null) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            if (lhValue == null) {
                return true;
            }
            if (Check_SVTB_10_1_1.this.pathIsPrewaived(this.parserPath)) {
                return true;
            }
            Check_SVTB_10_1_1.this.notifyCheckAlive();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (rhValue == null) {
                return true;
            }
            if (!(lhValue instanceof RfHidOperator) && !(rhValue instanceof RfHidOperator)) {
                return true;
            }
            if (lhValue instanceof RfHidOperator) {
                this.handleOperator((RfHidOperator)lhValue, operator);
            }
            if (rhValue instanceof RfHidOperator) {
                this.handleOperator((RfHidOperator)rhValue, operator);
            }
            return true;
        }

        private void handleOperator(RfHidOperator operator, RfHidOperator parentOperator) {
            if (!operator.isArithmetic()) {
                return;
            }
            if (this.validOperatorOrder(operator, parentOperator)) {
                return;
            }
            if (operator.getReparseInfo() == null) {
                Check_SVTB_10_1_1.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Macro `" + parentOperator.getReparseInfo().getLastReparseMacroName() + " contains arithmetic operations not enclosed in parenthesis, the expression using the macro might not have the intended result!");
            } else if (!operator.getReparseInfo().equals(parentOperator.getReparseInfo())) {
                List<ReparseInfo.ReparseElement> reparseStack;
                List<ReparseInfo.ReparseElement> parentReparseStack;
                IReparseInfo parentReparseInfo = parentOperator.getReparseInfo();
                IReparseInfo reparseInfo = operator.getReparseInfo();
                if (parentReparseInfo instanceof ReparseInfo && reparseInfo instanceof ReparseInfo && (parentReparseStack = Arrays.asList(((ReparseInfo)parentReparseInfo).getReparseStack())).containsAll(reparseStack = Arrays.asList(((ReparseInfo)reparseInfo).getReparseStack()))) {
                    Check_SVTB_10_1_1.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Macro `" + parentOperator.getReparseInfo().getLastReparseMacroName() + " contains arithmetic operations not enclosed in parenthesis, the expression using the macro might not have the intended result!");
                }
            } else {
                ListContainer rhValues;
                IHidObject lhValue = operator.getLHValue();
                if (lhValue instanceof RfHidOperator) {
                    this.handleOperator((RfHidOperator)lhValue, operator);
                }
                if ((rhValues = operator.getRHValues()) != null && rhValues.size() == 1 && rhValues.get(0) instanceof RfHidOperator) {
                    this.handleOperator((RfHidOperator)rhValues.get(0), operator);
                }
            }
        }

        private boolean validOperatorOrder(RfHidOperator operator, RfHidOperator parentOperator) {
            return parentOperator.isPlus() ? operator.isPlus() : (parentOperator.isMinus() ? operator.isPlus() : (parentOperator.getOperatorType() == 462 ? operator.getOperatorType() == 462 : (parentOperator.getOperatorType() == 463 ? operator.getOperatorType() == 462 : parentOperator.getOperatorType() == 506 && operator.getOperatorType() == 506)));
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

