/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="19.1.41")
@CheckID(value="SVTB.10.20")
@CheckName(value="SVTB.10.20")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.PREDEFINED_METHOD, RuleLabel.PERFORMANCE, RuleLabel.FORMAT_SPECIFIER})
@CheckTitle(value="Do not use formatting methods if no formatting is done in them")
@CheckDescription(value="This rule verifies that the format string argument of the $sformat, $sformatf and $psprintf methods has at least one valid format specifier.\n\nExamples:\n\nfunction void foo()\n\tstring s;\n\t$sformat(s, \"\"); // not allowed\n\t$psprintf(\"abc %d %d\", s, s); // allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_20
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro name patterns. Formatting done inside macros that match any of the specified patterns will be skipped.", name="skipMacroPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pSkipMacroPatterns;
    private static final Set<String> FORMATTING_METHODS = new HashSet<String>();
    private static final Character BANNED_CHARACTER = Character.valueOf('%');

    static {
        FORMATTING_METHODS.add("$sformat");
        FORMATTING_METHODS.add("$sformatf");
        FORMATTING_METHODS.add("$psprintf");
    }

    public Check_SVTB_10_20(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new RfHidVisitor(){
            private ParserPath parserPath;

            @Override
            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(RfHid hid) {
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (Check_SVTB_10_20.this.pathIsPrewaived(this.parserPath)) {
                    return true;
                }
                if (Check_SVTB_10_20.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    Collection<String> enclosingMacroNames;
                    Check_SVTB_10_20.this.notifyCheckAlive();
                    if (!FORMATTING_METHODS.contains(methodCall.getMethodName())) continue;
                    if (!Check_SVTB_10_20.this.pSkipMacroPatterns.isEmpty() && (enclosingMacroNames = this.getEnclosingMacroNames(hid)) != null) {
                        for (String macroName : enclosingMacroNames) {
                            if (macroName == null) continue;
                            for (Pattern pattern : Check_SVTB_10_20.this.pSkipMacroPatterns) {
                                Matcher m = pattern.matcher(macroName);
                                if (!m.matches()) continue;
                                return true;
                            }
                        }
                    }
                    if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) {
                        Check_SVTB_10_20.this.addHit(this.parserPath, methodCall.occurrence.getLine(), String.valueOf(methodCall.getMethodName()) + " has no formatting done in it.", null);
                        continue;
                    }
                    Map argumentValuesMapRaw = methodCall.argumentValuesMapRaw;
                    boolean shouldAddHit = true;
                    for (Map.Entry argumentValue : argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                        IHidObject value = (IHidObject)argumentValue.getValue();
                        if (!(key instanceof RfPredefinedField) || !key.getName().equals("format_string") || !this.hasFormatArgumentInMethod(value)) continue;
                        if (this.isUnnecessaryFormatting(value)) {
                            Check_SVTB_10_20.this.addHit(this.parserPath, methodCall.occurrence.getLine(), String.valueOf(methodCall.getMethodName()) + " is an unnecessary formatting.", null);
                        }
                        shouldAddHit = false;
                        break;
                    }
                    if (!shouldAddHit) continue;
                    Check_SVTB_10_20.this.addHit(this.parserPath, methodCall.occurrence.getLine(), String.valueOf(methodCall.getMethodName()) + " has no formatting done in it.", null);
                }
                return true;
            }

            private Collection<String> getEnclosingMacroNames(RfHid hid) {
                ArrayList<String> enclosingMacroNames = new ArrayList<String>();
                IReparseInfo iReparseInfo = hid.getReparseInfo();
                if (iReparseInfo == null) {
                    return null;
                }
                if (!(iReparseInfo instanceof ReparseInfo)) {
                    return null;
                }
                ReparseInfo reparseInfo = (ReparseInfo)iReparseInfo;
                ReparseInfo.ReparseElement[] reparseElementArray = reparseInfo.getReparseStack();
                int n = reparseElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReparseInfo.ReparseElement reparseElement = reparseElementArray[n2];
                    enclosingMacroNames.add(reparseElement.getReparseMacroName());
                    ++n2;
                }
                return enclosingMacroNames;
            }

            private boolean hasFormatArgumentInMethod(IHidObject value) {
                if (value == null) {
                    return false;
                }
                if (!(value instanceof RfHidImplicit)) {
                    return true;
                }
                String formatString = null;
                if (value instanceof RfHidImplicit && ((RfHidImplicit)value).isStringLiteral()) {
                    formatString = ((RfHidImplicit)value).getName();
                }
                return formatString != null && this.isFormattingDoneInString(formatString);
            }

            private boolean isFormattingDoneInString(String formatString) {
                formatString = formatString.substring(1, formatString.length() - 1);
                int i = 0;
                while (i < formatString.length() - 1) {
                    char first = formatString.charAt(i);
                    char second = formatString.charAt(i + 1);
                    boolean foundDot = false;
                    if (first == '%') {
                        if (LintUtilsConstants.FORMAT_SPECIFIERS.contains(Character.valueOf(second)) && !BANNED_CHARACTER.equals(Character.valueOf(second))) {
                            return true;
                        }
                        if (second == '%') {
                            ++i;
                        } else if (!BANNED_CHARACTER.equals(Character.valueOf(second))) {
                            int j = i + 1;
                            if (formatString.charAt(j) == '-') {
                                ++j;
                            }
                            while (j < formatString.length()) {
                                second = formatString.charAt(j);
                                if (LintUtilsConstants.FORMAT_SPECIFIERS.contains(Character.valueOf(second)) && !BANNED_CHARACTER.equals(Character.valueOf(second))) {
                                    if (foundDot && !LintUtilsConstants.FORMAT_SPECIFIERS_REAL_NUMBERS.contains(Character.valueOf(second))) break;
                                    return true;
                                }
                                if (!Character.isDigit(second)) {
                                    if (second != '.' || foundDot) break;
                                    foundDot = true;
                                }
                                ++j;
                            }
                            i = j;
                        }
                    }
                    ++i;
                }
                return false;
            }

            private boolean isUnnecessaryFormatting(IHidObject value) {
                if (value == null) {
                    return false;
                }
                if (!(value instanceof RfHidImplicit)) {
                    return false;
                }
                String formatString = null;
                if (value instanceof RfHidImplicit && ((RfHidImplicit)value).isStringLiteral()) {
                    formatString = ((RfHidImplicit)value).getName();
                }
                if (formatString == null) {
                    return false;
                }
                return formatString.equals("\"%s\"") || formatString.equals("\"%0s\"") || formatString.equals("\"%S\"") || formatString.equals("\"%0S\"");
            }
        });
    }

    protected boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

