/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="20.1.23")
@CheckID(value="SVTB.10.21")
@CheckName(value="SVTB.10.21")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CLOCKING_BLOCK})
@CheckTitle(value="Do not combine driver and output clockvar")
@CheckDescription(value="If a variable is driven by a continuous assignment or primitive output, then no output clockvar in the clocking block to that variable is allowed.")
public class Check_SVTB_10_21
extends OVMComplianceCheck {
    private HashMap<RfNamedElement, Set<String>> outputClockVars;

    public Check_SVTB_10_21(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.outputClockVars = new HashMap();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new IHidVisitor<RfHidOperator>(){
            protected ParserPath parserPath;

            public boolean visit(RfHidOperator hidOperator) {
                if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN)) {
                    return true;
                }
                if (Check_SVTB_10_21.this.isPrewaived(this.parserPath)) {
                    return true;
                }
                Check_SVTB_10_21.this.notifyCheckAlive();
                Set lhHids = hidOperator.getLHHids(HidFlatteningOption.NONE_EXCLUDED);
                for (IHid hid : lhHids) {
                    if (!(hid instanceof RfHid)) continue;
                    IRfNamedElement element = hid.getElement();
                    if (!(element instanceof RfField)) {
                        return true;
                    }
                    if (!Check_SVTB_10_21.this.checkOutputClockVar(element)) continue;
                    Check_SVTB_10_21.this.addHit(this.parserPath, (RfHid)hid, "Illegal combination of driver and output clockvar to variable " + element.getName() + "!");
                }
                return true;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }
        });
        this.checkIllegalDrivingInInstances(this.fOVMProject.getAllInstances());
    }

    private void checkIllegalDrivingInInstances(NullProtectedList<RfNamedElement> instances) {
        for (RfNamedElement instance : instances) {
            RfFileDef file = instance.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<IHidOperator> operators = instance.getHidOperators(ELConstants.PORT_CONNECTIONS_QUALIFIERS_ARRAY, true);
            if (operators == null || operators.isEmpty()) continue;
            block1: for (IHidOperator operator : operators) {
                Set signalsHids;
                IHid portHid = PortConnectionUtils.getPortHid((IHidOperator)operator);
                IRfNamedElement port = HidUtils.getResolvedElement((IHidObject)portHid);
                if (!(port instanceof RfPort) || !((RfPort)port).isOutput() || (signalsHids = PortConnectionUtils.getSignalHids((IHidOperator)operator, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED)) == null || signalsHids.isEmpty()) continue;
                for (IHid signalHid : signalsHids) {
                    IRfNamedElement element;
                    if (!(signalHid instanceof RfHid) || !((element = HidUtils.getResolvedElement((IHidObject)signalHid)) instanceof RfField) || !this.checkOutputClockVar(element)) continue;
                    this.addHit(file.getParserPath(), (RfHid)signalHid, "Illegal combination of driver and output clockvar to variable " + element.getName() + "!");
                    continue block1;
                }
            }
        }
    }

    public boolean checkOutputClockVar(IRfNamedElement element) {
        IRfScopeElement enclosingScopeInt = element.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN);
        if (!(enclosingScopeInt instanceof RfNamedElement)) {
            return false;
        }
        RfNamedElement enclosingScope = (RfNamedElement)enclosingScopeInt;
        if (!this.outputClockVars.containsKey(enclosingScope)) {
            this.outputClockVars.put(enclosingScope, this.computeAllOutputClockVars(enclosingScope));
        }
        return this.outputClockVars.get(enclosingScope) != null && this.outputClockVars.get(enclosingScope).contains(element.getName());
    }

    public Set<String> computeAllOutputClockVars(RfNamedElement enclosingScope) {
        List<RfClockingBlock> clkBlocks = enclosingScope.getClockingBlocksWithPrefix("", 2, 1);
        if (clkBlocks == null || clkBlocks.isEmpty()) {
            return null;
        }
        HashSet<String> outputClockVarNames = new HashSet<String>();
        for (RfClockingBlock clockingBlock : clkBlocks) {
            List<RfField> candidates = clockingBlock.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates == null || candidates.isEmpty()) {
                return null;
            }
            for (RfField candidate : candidates) {
                if (!(candidate instanceof RfModportPort) || !candidate.isOutput()) continue;
                outputClockVarNames.add(candidate.getName());
            }
        }
        return outputClockVarNames;
    }

    public boolean isPrewaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

