/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.44")
@CheckID(value="SVTB.10.22")
@CheckName(value="SVTB.10.22")
@CheckLabel(labels={RuleLabel.OPERATOR})
@CheckTitle(value="Variables should not be shifted by zero or more than their number of bits-1")
@CheckDescription(value="Shifting a variable by zero bits has no effect on the value of the variable.\nShifting a variable by more than it's number of bits will make the variable either zero or if the variable is signed it will turn all the bits into 1.\nAny of the efects of such shifts can be done in a much clearer way and it is not necesarry to use a number greater than the number of bits.\n\nExamples:\n\nfunction void foo()\n\tbit[31:0] val1;\n\tval1 = val1 >> 38; // not allowed\n\tval1 = val1 >> 0; // not allowed\n\tval1 = val1 << 5; // allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_22
extends OVMComplianceCheck {
    public Check_SVTB_10_22(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new RfHidOperatorVisitor());
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class RfHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        private RfHidOperatorVisitor() {
        }

        public boolean visit(RfHidOperator hidObject) {
            if (Check_SVTB_10_22.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_10_22.this.notifyCheckAlive();
            if (hidObject.isArithmeticShift() || hidObject.isLogicalShift()) {
                this.handleEqualShift(hidObject);
            }
            return true;
        }

        private void handleEqualShift(RfHidOperator hidObject) {
            if (!(hidObject.getLHValue() instanceof RfHid)) {
                return;
            }
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.isEmpty() || !(rhValues.get(0) instanceof RfHidImplicit)) {
                return;
            }
            RfHidImplicit hidImplicit = (RfHidImplicit)rhValues.get(0);
            Number number = hidImplicit.parseNumberValue();
            int noBits = HidUtils.nofBits((IHidObject)hidObject.getLHValue(), (boolean)false);
            if (noBits == -1) {
                return;
            }
            if (number != null) {
                if (number.intValue() >= noBits) {
                    Check_SVTB_10_22.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Variable '" + HidUtils.toNiceString((IHidObject)hidObject.getLHValue()) + "' is shifted by more than it's number of bits!");
                }
                if (number.intValue() == 0) {
                    Check_SVTB_10_22.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Variable '" + HidUtils.toNiceString((IHidObject)hidObject.getLHValue()) + "' is shifted by zero bits!");
                }
            }
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

