/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.44")
@CheckID(value="SVTB.10.23")
@CheckName(value="SVTB.10.23")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.PERFORMANCE})
@CheckTitle(value="Values should not be uselessly incremented or decremented")
@CheckDescription(value="This rule checks if values are uselessly incremented or decremented.\nExamples:\ni = i++; // NOT ALLOWED\nreturn x++; // ALLOWED iff skipStaticStorageVariables\ni++; // ALLOWED\nreturn ++x; // ALLOWED\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_23
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, static storage variables in return statements are skipped by this rule.", name="skipStaticStorageVariables", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipStaticStorageVariables;
    private Map<RfHid, Boolean> varMap = new HashMap<RfHid, Boolean>();
    private final HidOperatorVisitor fIncrementsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidObject) {
            if (Check_SVTB_10_23.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_10_23.this.notifyCheckAlive();
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)hidObject;
                if (operator.isReturnStatement()) {
                    Check_SVTB_10_23.this.varMap.clear();
                    Check_SVTB_10_23.this.checkExpression((IHidObject)operator.getRHValues().get(0));
                    for (Map.Entry<RfHid, Boolean> entry : Check_SVTB_10_23.this.varMap.entrySet()) {
                        IRfNamedElement element = entry.getKey().getElement();
                        if (element == null || element.getEnclosingScope(RfFunction.class) == null || Check_SVTB_10_23.this.pSkipStaticStorageVariables && element.isStorageStatic() || !entry.getValue().booleanValue()) continue;
                        Check_SVTB_10_23.this.addHit(this.parserPath, hidObject.getOccurrence().getLine(), String.valueOf(HidUtils.toNiceString((IHidObject)((IHidObject)entry.getKey()))) + " uselessly incremented! ", null);
                    }
                }
                if (operator.isAssignment()) {
                    Check_SVTB_10_23.this.varMap.clear();
                    IHidObject lhValue = operator.getLHValue();
                    if (lhValue instanceof RfHid) {
                        RfHid leftVar = (RfHid)lhValue;
                        if (operator.getRHValues() != null && !operator.getRHValues().isEmpty()) {
                            Check_SVTB_10_23.this.checkExpression((IHidObject)operator.getRHValues().get(0));
                            for (Map.Entry<RfHid, Boolean> entry : Check_SVTB_10_23.this.varMap.entrySet()) {
                                IRfNamedElement element = entry.getKey().getElement();
                                if (element == null || !entry.getValue().booleanValue() || !entry.getKey().getName().equals(leftVar.getName())) continue;
                                Check_SVTB_10_23.this.addHit(this.parserPath, hidObject.getOccurrence().getLine(), String.valueOf(entry.getKey().getName()) + " uselessly incremented! ", null);
                            }
                        }
                    }
                }
            }
            return true;
        }
    };

    public Check_SVTB_10_23(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    void checkExpression(IHidObject hidObject) {
        if (hidObject instanceof RfHid) {
            RfHid operand = (RfHid)hidObject;
            this.varMap.put(operand, false);
        }
        if (hidObject instanceof RfHidOperator) {
            ListContainer rhValues;
            RfHid operand;
            IHidObject value;
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (operator.isIncrementOrDecrement() && (value = operator.getLHValue()) instanceof RfHid && (operand = (RfHid)value).getOccurrence().getOffset() < operator.getOccurrence().getOffset()) {
                this.varMap.put(operand, true);
                return;
            }
            IHidObject lhValue = operator.getLHValue();
            if (lhValue != null) {
                this.checkExpression(lhValue);
            }
            if ((rhValues = operator.getRHValues()) != null && !rhValues.isEmpty()) {
                this.checkExpression((IHidObject)rhValues.get(0));
            }
        }
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fIncrementsVisitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

