/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractLiteralComparison;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="21.1.11")
@CheckID(value="SVTB.10.24")
@CheckName(value="SVTB.10.24")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ENUM, RuleLabel.LITERAL_VALUE, RuleLabel.COMPARISON})
@CheckTitle(value="Do not compare enum variables to literals or enum items not from the enum type")
@CheckDescription(value="Comparison between enum variables and literal values or enum values from other enum types is not allowed.\nEnum variables should only be compared with enum items from the enum type.\nThis will ensure the code is easily understandable and it will protect from potential bugs when adding enum items to the enum type.\nComparisons between concatenated variables or enum items are checked only for comparisons of the same number of concatenated elements.\n\nExamples:\n\ntypedef enum logic [4:0] {red, green, blue} colors;\ntypedef enum logic [4:0] {large, medium, small} size;\nfunction void foo()\n\tcolors c;\n\tif (c == large) // not allowed\n\t\t$display(\"Test1\");\n\tif (c == red) // allowed\n\t\t$display(\"Test2\");\n\tif (c == 'b10001) // not allowed\n\t\t$display(\"Test3\");\nendfunction\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="skipConcatenationComparison", defaultValue="false", isVisible=true)
public class Check_SVTB_10_24
extends AbstractLiteralComparison {
    @CheckParameter(defaultValue="false", description="When true, skip bit selects over enums.", name="skipBitSelects", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipBitSelects;

    public Check_SVTB_10_24(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkComparison(ParserPath path, HidOperator hidOperator, IHid lhValue, DVTPair<AbstractLiteralComparison.Type, Object> lhPair, IHid rhValue, DVTPair<AbstractLiteralComparison.Type, Object> rhPair) {
        if (lhValue == null || rhValue == null) {
            return;
        }
        boolean lhBitSelect = false;
        boolean rhBitSelect = false;
        if (this.pSkipBitSelects) {
            if (lhValue instanceof Hid) {
                lhBitSelect = LintUtils.isBitSelect((RfHid)lhValue, null);
            }
            if (rhValue instanceof Hid) {
                rhBitSelect = LintUtils.isBitSelect((RfHid)rhValue, null);
            }
        }
        if (!rhBitSelect) {
            if (lhPair.getKey() == AbstractLiteralComparison.Type.LITERAL && rhPair.getKey() == AbstractLiteralComparison.Type.FIELD_WITH_ENUM_DATATYPE) {
                this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of enum variable '" + rhValue.getName() + "' with literal '" + lhValue.getName() + "'!");
                return;
            }
            if (rhPair.getKey() == AbstractLiteralComparison.Type.FIELD_WITH_ENUM_DATATYPE && lhPair.getKey() == AbstractLiteralComparison.Type.ENUM_ELEMENT && !lhPair.getValue().equals(rhPair.getValue())) {
                this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of enum variable '" + rhValue.getName() + "' with enum item '" + lhValue.getName() + "' with different type!");
                return;
            }
        }
        if (!lhBitSelect) {
            if (rhPair.getKey() == AbstractLiteralComparison.Type.LITERAL && lhPair.getKey() == AbstractLiteralComparison.Type.FIELD_WITH_ENUM_DATATYPE) {
                this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of enum variable '" + lhValue.getName() + "' with literal '" + rhValue.getName() + "'!");
                return;
            }
            if (lhPair.getKey() == AbstractLiteralComparison.Type.FIELD_WITH_ENUM_DATATYPE && rhPair.getKey() == AbstractLiteralComparison.Type.ENUM_ELEMENT && !lhPair.getValue().equals(rhPair.getValue())) {
                this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of enum variable '" + lhValue.getName() + "' with enum item '" + rhValue.getName() + "' with different type!");
                return;
            }
        }
    }
}

