/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_10_6_1_0;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.10.6.1")
@CheckName(value="SVTB.10.6.1")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONDITIONAL})
@CheckTitle(value="Type of the ternary operator conditional expression")
@CheckDescription(value="The conditional expression of the ternary operator must be bit or logic.\n\nExamples:\nmy_int = (my_bit == 1) ? 'd6 : 'd7; // allowed\nmy_int = (my_bit) ? 'd6 : 'd7; // allowed\nmy_int = (my_class == null) ? 'd6 : 'd7; // allowed \nmy_int = (my_semaphore) ? 'd6 : 'd7; // not allowed\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="looselyCastToBoolTypes", isVisible=false), @CheckParameterOverride(name="allowedFunctions", defaultValue="", isVisible=false)})
public class Check_SVTB_10_6_1
extends Check_SVTB_10_6_1_0 {
    public Check_SVTB_10_6_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getFailMessage(IHidObject hidObject) {
        return "The conditional expression '" + HidUtils.toNiceString((IHidObject)hidObject) + "' of the ternary operator is not bit or logic!";
    }
}

