/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SDataType;

@CheckVersion(value="3.1.3")
@CheckID(value="SVTB.10.6.1.0")
@CheckName(value="SVTB.10.6.1.0")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONDITIONAL})
@CheckTitle(value="Type of conditional expression in ternary conditional operator")
@CheckDescription(value="The conditional expression of the ternary conditional operator must be bit, logic or a type that can loosely cast to a boolean specified by the looselyCastToBoolTypes parameter.\n\nExamples:\nmy_int = (my_bit == 1) ? 'd6 : 'd7; // allowed\nmy_int = (my_bit) ? 'd6 : 'd7; // allowed \nmy_int = (my_class == null) ? 'd6 : 'd7; // allowed\nmy_int = (my_semaphore) ? 'd6 : 'd7; // not allowed, unless 'semaphore' is in the 'looselyCastToBoolTypes'\n\nCheck supports pre-waiving.")
public class Check_SVTB_10_6_1_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of allowed types other than bit or logic.", name="looselyCastToBoolTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pLooselyCastToBoolTypesValue;
    @CheckParameter(defaultValue="$test$plusargs", description="Comma separated list of functions and tasks allowed as conditional expression.", name="allowedFunctions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pAllowedFunctions;
    private final HidOperatorVisitor conditionalExpresionVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidOperator) {
            if (!hidOperator.isConditionalTernary()) {
                return true;
            }
            if (Check_SVTB_10_6_1_0.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                return true;
            }
            Check_SVTB_10_6_1_0.this.notifyCheckAlive();
            if (lhValue instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)lhValue;
                if (operator.isEqualityOrInequality() || operator.isLogical() || operator.isInside() || operator.isInsideSet() || operator.isWildcardEquality() || operator.isRelational() || operator.isReduction()) {
                    return true;
                }
                if (operator.isConditionalTernary()) {
                    this.handleConditional(operator);
                    return true;
                }
                this.handleOperator(operator);
            } else if (lhValue instanceof RfHid) {
                this.handleHid((RfHid)lhValue, hidOperator, false);
            } else if (lhValue instanceof RfHidAccess) {
                this.handleAccess((RfHidAccess)lhValue, hidOperator, false);
            } else if (lhValue instanceof RfHidImplicit) {
                this.handleImplicit((RfHidImplicit)lhValue, hidOperator, false);
            }
            return true;
        }

        private void handleImplicit(RfHidImplicit implicit, HidOperator hidOperator, boolean showAllOperator) {
            String value = implicit.getName();
            if (value.equals("0") || value.equals("1")) {
                return;
            }
            Number number = implicit.parseNumberValue();
            if (number != null && (number.intValue() == 0 || number.intValue() == 1)) {
                return;
            }
            Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), showAllOperator ? Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)hidOperator) : Check_SVTB_10_6_1_0.this.getFailMessage(hidOperator.getLHValue()));
        }

        private void handleAccess(RfHidAccess value, HidOperator hidOperator, boolean showAllOperator) {
            IRfNamedElement dataType;
            List selects = value.getSelects();
            boolean singleSelect = true;
            if (selects != null) {
                for (IHidObject select : selects) {
                    if (select instanceof RfHidOperator) {
                        if (this.checkSingleSelect((RfHidOperator)select)) continue;
                        singleSelect = false;
                    } else {
                        singleSelect = false;
                    }
                    break;
                }
            } else {
                singleSelect = false;
            }
            if (singleSelect) {
                return;
            }
            if (value.getParentHid() != null) {
                RfFunction function;
                IRfNamedElement functionType;
                Hid parentHid = value.getParentHid();
                if (parentHid.getName().equals("$cast")) {
                    return;
                }
                if (parentHid.getElement() instanceof RfFunction && Check_SVTB_10_6_1_0.this.pAllowedFunctions.contains(((RfFunction)parentHid.getElement()).getFullName())) {
                    return;
                }
                if (parentHid.getElement() instanceof RfFunction && (functionType = (function = (RfFunction)parentHid.getElement()).getAssociatedType()) instanceof RfNamedElement) {
                    IRfNamedElement resolvedType;
                    String resolvedTypeName;
                    if (functionType instanceof RfTypeAlias && Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(resolvedTypeName = (resolvedType = ((RfTypeAlias)functionType).getAssociatedType()).getName(), Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue)) {
                        return;
                    }
                    String dataTypeName = ((RfNamedElement)functionType).getFullName();
                    if (Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(dataTypeName, Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue)) {
                        return;
                    }
                    Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), showAllOperator ? Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)hidOperator) : Check_SVTB_10_6_1_0.this.getFailMessage(hidOperator.getLHValue()));
                }
            }
            if ((dataType = value.getAssociatedType()) instanceof RfNamedElement && Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(dataType, Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue)) {
                return;
            }
            if (dataType instanceof RfTypeAlias) {
                dataType = LintUtils.getAssociatedFinalType((RfTypeAlias)dataType);
            }
            if (Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(dataType, Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue)) {
                return;
            }
            Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), showAllOperator ? Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)hidOperator) : Check_SVTB_10_6_1_0.this.getFailMessage(hidOperator.getLHValue()));
        }

        private void handleHid(RfHid hid, HidOperator operator, boolean showAllOperator) {
            IRfNamedElement element = hid.getElement();
            if (element instanceof RfAssociatedType) {
                RfNamedElement dataType;
                IRfNamedElement type = ((RfAssociatedType)element).getAssociatedType();
                if (type instanceof RfListType) {
                    if (RfListType.isNotFixedArray((IRfScopeElement)type) || type instanceof RfInstance.RfInstanceList) {
                        Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), showAllOperator ? Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)operator) : Check_SVTB_10_6_1_0.this.getFailMessage(operator.getLHValue()));
                        return;
                    }
                    List<IndexType> packedDimensions = ((RfListType)type).getDataType().getPackedDimension();
                    if (packedDimensions != null) {
                        for (IndexType dimension : packedDimensions) {
                            if (!(dimension.getRangeObject() instanceof RfHidOperator) || this.checkSingleSelect((RfHidOperator)dimension.getRangeObject())) continue;
                            Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), showAllOperator ? Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)operator) : Check_SVTB_10_6_1_0.this.getFailMessage(operator.getLHValue()));
                            return;
                        }
                    }
                }
                if (Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(dataType = LintUtils.getAssociatedFinalType((RfAssociatedType)element), Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue) || Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(type, Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue)) {
                    return;
                }
                Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), showAllOperator ? Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)operator) : Check_SVTB_10_6_1_0.this.getFailMessage(operator.getLHValue()));
            }
        }

        private void handleOperator(RfHidOperator operator) {
            if (operator.getLHValue() == null) {
                Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)operator));
                return;
            }
            if (!this.isUnderAlias(operator)) {
                IRfNamedElement dataType = this.getOperatorType(operator);
                if (dataType == null || !(dataType instanceof RfNamedElement)) {
                    Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)operator));
                    return;
                }
                if (dataType instanceof RfTypeAlias) {
                    dataType = LintUtils.getAssociatedFinalType((RfTypeAlias)dataType);
                }
                if (Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(dataType, Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue)) {
                    return;
                }
                Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)operator));
            } else {
                IRfNamedElement operatorType = this.getOperatorType(operator);
                if (operatorType == null) {
                    return;
                }
                String originalOperatorType = operatorType.getName();
                if (originalOperatorType.equals("bit") || originalOperatorType.equals("logic")) {
                    return;
                }
                String aliasType = this.getAliasType(operator);
                if (!Check_SVTB_10_6_1_0.this.isLooselyCastToBoolType(aliasType, Check_SVTB_10_6_1_0.this.pLooselyCastToBoolTypesValue)) {
                    Check_SVTB_10_6_1_0.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), Check_SVTB_10_6_1_0.this.getFailMessage((IHidObject)operator));
                }
            }
        }

        private String getAliasType(RfHid hid) {
            IRfNamedElement namedElement = hid.getElement();
            StringBuilder result = new StringBuilder();
            Hid parentHid = hid.getParentHid();
            if (parentHid != null) {
                result.append(this.getAliasType((IHidObject)parentHid));
                result.append("::");
            }
            if (namedElement instanceof RfTypeAlias) {
                result.append(((RfTypeAlias)namedElement).getName());
            } else if (namedElement instanceof RfPackage) {
                result.append(((RfPackage)namedElement).getName());
            } else if (namedElement instanceof RfAssociatedType) {
                result.append(((RfAssociatedType)namedElement).getAssociatedTypeName());
            }
            return result.toString();
        }

        private String getAliasType(RfHidAccessArgs hid) {
            Hid parent = hid.getParentHid();
            if (!(parent instanceof RfHid)) {
                return "";
            }
            RfHid parentHid = (RfHid)parent;
            if (parentHid.getElement() instanceof RfFunction) {
                RfFunction function = (RfFunction)parentHid.getElement();
                DataType dataType = function.getDataType();
                return dataType != null ? dataType.getTypeName(null, null) : "";
            }
            return "";
        }

        public String getAliasType(IHidObject hidObject) {
            if (hidObject instanceof RfHidOperator) {
                return this.getAliasType((RfHidOperator)hidObject);
            }
            if (hidObject instanceof RfHid) {
                return this.getAliasType((RfHid)hidObject);
            }
            if (hidObject instanceof RfHidAccessArgs) {
                return this.getAliasType((RfHidAccessArgs)hidObject);
            }
            return "";
        }

        private String getAliasType(RfHidOperator operator) {
            IHidObject leftHid = operator.getLHValue();
            ListContainer right = operator.getRHValues();
            String associatedTypeLeft = "";
            String associatedTypeRight = "";
            associatedTypeLeft = this.getAliasType(leftHid);
            if (operator.isTickCast()) {
                return associatedTypeLeft;
            }
            if (right != null) {
                for (IHidObject hidObject : right) {
                    associatedTypeRight = this.getAliasType(hidObject);
                    if (associatedTypeLeft.equals(associatedTypeRight)) continue;
                    ISDataAbstract resolvedType = operator.getOperatorResolvedType();
                    ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
                    if (!(dataType instanceof SDataType)) {
                        return associatedTypeLeft;
                    }
                    IRfTypeAliasElement aliasType = ((SDataType)dataType).getAliasType();
                    return aliasType != null ? aliasType.getName() : "";
                }
            }
            return associatedTypeLeft;
        }

        private boolean isUnderAlias(RfHidOperator operator) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
            if (dataType == null) {
                return false;
            }
            return dataType.isUnderAlias();
        }

        private void handleConditional(RfHidOperator operator) {
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null) {
                return;
            }
            for (IHidObject value : rhValues) {
                if (value == null) continue;
                if (value instanceof RfHidOperator) {
                    if (((RfHidOperator)value).isConditionalTernary()) {
                        this.handleConditional((RfHidOperator)value);
                        continue;
                    }
                    this.handleOperator((RfHidOperator)value);
                    continue;
                }
                if (value instanceof RfHid) {
                    this.handleHid((RfHid)value, operator, true);
                    continue;
                }
                if (value instanceof RfHidAccess) {
                    this.handleAccess((RfHidAccess)value, operator, true);
                    continue;
                }
                if (!(value instanceof RfHidImplicit)) continue;
                this.handleImplicit((RfHidImplicit)value, operator, true);
            }
        }

        private boolean checkSingleSelect(RfHidOperator select) {
            IHidObject lhValue = select.getLHValue();
            ListContainer rhValues = select.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return false;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (lhValue instanceof RfHidImplicit && rhValue instanceof RfHidImplicit && ((RfHidImplicit)lhValue).getName().equals(((RfHidImplicit)rhValue).getName())) {
                return true;
            }
            return lhValue instanceof RfHid && rhValue instanceof RfHid && ((RfHid)lhValue).getElement().equals(((RfHid)rhValue).getElement());
        }

        private IRfNamedElement getOperatorType(HidOperator operator) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
            if (dataType != null && dataType != SDataAbstracts.ILLEGAL && dataType != SDataAbstracts.UNDEFINED) {
                return dataType.getType();
            }
            return null;
        }
    };

    public Check_SVTB_10_6_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.conditionalExpresionVisitor);
    }

    protected String getFailMessage(IHidObject hidObject) {
        return "The conditional expression '" + HidUtils.toNiceString((IHidObject)hidObject) + "' of the ternary operator is not bit, logic or a type that can be loosely cast to boolean!";
    }

    boolean isLooselyCastToBoolType(IRfNamedElement aNamedElement, HashSet<String> aLooselyCastToBoolTypes) {
        if (aNamedElement == null) {
            return false;
        }
        if (aNamedElement instanceof RfPredefinedScalarType || aNamedElement instanceof RfClass || aNamedElement instanceof RfTypeAlias) {
            String elementName = ((RfNamedElement)aNamedElement).getFullName();
            if (elementName.equals("bit") || elementName.equals("logic")) {
                return true;
            }
            return aLooselyCastToBoolTypes.contains(elementName);
        }
        return false;
    }

    private boolean isLooselyCastToBoolType(String operatorType, HashSet<String> aLooselyCastToBoolTypes) {
        if (operatorType.equals("bit") || operatorType.equals("logic")) {
            return true;
        }
        return aLooselyCastToBoolTypes.contains(operatorType);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

