/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.10.7.2")
@CheckName(value="SVTB.10.7.2")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.DELAY, RuleLabel.CLOCKING_BLOCK})
@CheckTitle(value="Do not specify delays outside of an interface clocking block")
@CheckDescription(value="Monitor and Bus Functional Model (BFM) events should occur with timing specified in the clocking block within the interface. Adding delays outside of the interface requires editing both the interface and the bfm and/or monitor if the interface timing is changed.\nException: async interfaces driven by a bfm can waive this rule.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_10_7_2
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="", description="Comma separated list of scopes where to check for delays: checker, class, constructor, function, interface, library, module, package, program and task..", name="checkedTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pCheckedTypes;
    private static HashSet<String> allScopes = new HashSet();
    private static HashSet<Class<? extends RfNamedElement>> allScopesClasses;
    private static final String CHECKER = "checker";
    private static final String CLASS = "class";
    private static final String CONSTRUCTOR = "constructor";
    private static final String FUNCTION = "function";
    private static final String INTERFACE = "interface";
    private static final String MODULE = "module";
    private static final String PACKAGE = "package";
    private static final String PROGRAM = "program";
    private static final String TASK = "task";

    static {
        allScopes.add(CHECKER);
        allScopes.add(CLASS);
        allScopes.add(CONSTRUCTOR);
        allScopes.add(FUNCTION);
        allScopes.add(INTERFACE);
        allScopes.add(MODULE);
        allScopes.add(PACKAGE);
        allScopes.add(PROGRAM);
        allScopes.add(TASK);
        allScopesClasses = new HashSet();
        allScopesClasses.add(RfChecker.class);
        allScopesClasses.add(RfClass.class);
        allScopesClasses.add(RfFunction.class);
        allScopesClasses.add(RfInterface.class);
        allScopesClasses.add(RfModule.class);
        allScopesClasses.add(RfPackage.class);
        allScopesClasses.add(RfProgram.class);
    }

    public Check_SVTB_10_7_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String allowedScope : this.pCheckedTypes) {
            if (allScopes.contains(allowedScope)) continue;
            this.signalParamError("'" + allowedScope + "' is not allowed as parameter!", true);
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(118);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Delay outside an interface clocking block";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(118);
        Set<ParserPath> keySet = allIssues.keySet();
        for (ParserPath filename : keySet) {
            List<SVTBIssues> issues;
            RfFileDef filedef;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(filename, this) || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename)) == null || (issues = allIssues.get(filename)) == null || issues.isEmpty()) continue;
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            this.notifyCheckAlive();
            for (SVTBIssues issue : issues) {
                RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
                RfNamedElement scope = defScope.getNamedElement();
                if (scope == null || scope instanceof RfClockingBlock && scope.getEnclosingScope() instanceof RfInterface) continue;
                boolean shouldCheckFlag = this.pCheckedTypes.isEmpty();
                while (!shouldCheckFlag && scope != null) {
                    if (this.shouldCheck(scope)) {
                        shouldCheckFlag = true;
                    }
                    scope = scope.getEnclosingScope();
                }
                if (!shouldCheckFlag) continue;
                filteredList.add(issue);
            }
            filteredMap.put(filename, filteredList);
        }
        return filteredMap;
    }

    private boolean shouldCheck(RfNamedElement namedElement) {
        if (this.pCheckedTypes.contains(CHECKER) && namedElement instanceof RfChecker) {
            return true;
        }
        if (this.pCheckedTypes.contains(CLASS) && namedElement instanceof RfClass) {
            return true;
        }
        if (this.pCheckedTypes.contains(INTERFACE) && namedElement instanceof RfInterface) {
            return true;
        }
        if (this.pCheckedTypes.contains(MODULE) && namedElement instanceof RfModule) {
            return true;
        }
        if (this.pCheckedTypes.contains(PACKAGE) && namedElement instanceof RfPackage) {
            return true;
        }
        if (this.pCheckedTypes.contains(PROGRAM) && namedElement instanceof RfProgram) {
            return true;
        }
        if (namedElement instanceof RfFunction) {
            RfFunction function = (RfFunction)namedElement;
            if (this.pCheckedTypes.contains(CONSTRUCTOR) && function.isConstructor()) {
                return true;
            }
            if (this.pCheckedTypes.contains(FUNCTION) && function.isFunction()) {
                return true;
            }
            if (this.pCheckedTypes.contains(TASK) && function.isTask()) {
                return true;
            }
        }
        return false;
    }
}

