/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_10_7_3;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.10.7.3")
@CheckName(value="SVTB.10.7.3")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.DELAY})
@CheckTitle(value="Do not use #0, ##0, #1step")
@CheckDescription(value="Do not use #0, ##0 or #1step to make your code 'work'.\n #1step and #0 are allowed inside clocking blocks.\n\nExamples:\nclocking clock1 @(posedge inout_name);\n  output #0 output_name; // allowed\nendclocking\n\ninitial begin\n  #1step input_name = 3; //not allowed\nend\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_10_7_3.class)
public class Check_SVTB_10_7_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="When true, the check will not flag ##0 in assertions.", name="skipCycleDelayInAssertions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCycleDelayInAssertions;
    private DocumentManager docManager;

    public Check_SVTB_10_7_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(106);
        aRfProject.lintTrackP2LInfo(11);
        aRfProject.lintTrackP2LInfo(107);
        aRfProject.lintTrackP2LInfo(105);
    }

    protected String getFailMessage(String text, int hitOffsetOnLine) {
        return String.valueOf(text) + " was used at line offset " + hitOffsetOnLine + "!";
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, List<SVTBIssues>> poundZero = this.fOVMProject.getSVTBIssuesWithKind(106);
        Map<ParserPath, List<SVTBIssues>> oneStep = this.fOVMProject.getSVTBIssuesWithKind(107);
        Map<ParserPath, List<SVTBIssues>> delayValues = this.fOVMProject.getSVTBIssuesWithKind(11);
        Map<ParserPath, List<SVTBIssues>> cycleDelays = this.fOVMProject.getSVTBIssuesWithKind(105);
        this.docManager = this.getDocumentManager();
        this.addIssues(poundZero, true);
        this.addIssues(oneStep, true);
        this.checkIssues(delayValues, false);
        this.checkIssues(cycleDelays, true);
        this.docManager.deactivate();
    }

    private void addIssues(Map<ParserPath, List<SVTBIssues>> allIssues, boolean exceptClockingBlocks) {
        Set<ParserPath> keySet = allIssues.keySet();
        for (ParserPath filename : keySet) {
            List<SVTBIssues> issues;
            RfFileDef filedef;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(filename, this) || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename)) == null || (issues = allIssues.get(filename)) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            IDocument document = this.docManager.getDocument(filename, this.getIProject());
            for (SVTBIssues issue : issues) {
                if (exceptClockingBlocks) {
                    RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
                    RfNamedElement scope = defScope.getNamedElement();
                    if (scope instanceof RfClockingBlock) continue;
                    int hitOffsetOnLine = this.getOffsetOnLine(document, issue);
                    this.addHit(filename, issue.getLine(), this.getFailMessage(issue.getInfo(), hitOffsetOnLine), issue.getReparseInfo(), new VerissimoAutofixAdditionalInfo(issue));
                    continue;
                }
                int hitOffsetOnLine = this.getOffsetOnLine(document, issue);
                this.addHit(filename, issue.getLine(), this.getFailMessage(issue.getInfo(), hitOffsetOnLine), issue.getReparseInfo(), new VerissimoAutofixAdditionalInfo(issue));
            }
        }
    }

    private void checkIssues(Map<ParserPath, List<SVTBIssues>> allIssues, boolean isCycleDelay) {
        if (isCycleDelay && this.pSkipCycleDelayInAssertions) {
            allIssues = LintUtils.removeCycleDelayIssuesInAssertions(this.fOVMProject.getRfProject(), allIssues);
        }
        Set<ParserPath> keySet = allIssues.keySet();
        for (ParserPath filename : keySet) {
            List<SVTBIssues> issues;
            RfFileDef filedef;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(filename, this) || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename)) == null || (issues = allIssues.get(filename)) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            IDocument document = this.docManager.getDocument(filename, this.getIProject());
            for (SVTBIssues issue : issues) {
                String prefix;
                if ("##0".equals(issue.getInfo()) || "#0".equals(issue.getInfo())) {
                    int hitOffsetOnLine = this.getOffsetOnLine(document, issue);
                    this.addHit(filename, issue.getLine(), this.getFailMessage(issue.getInfo(), hitOffsetOnLine), issue.getReparseInfo(), new VerissimoAutofixAdditionalInfo(issue));
                    continue;
                }
                String varName = issue.getInfo();
                String string = prefix = isCycleDelay ? "" : "#";
                if (varName == null) continue;
                if (varName.startsWith("##")) {
                    varName = varName.substring(2);
                    prefix = "##";
                } else if (varName.startsWith("#")) {
                    varName = varName.substring(1);
                    prefix = "#";
                }
                RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
                RfNamedElement scope = defScope.getNamedElement();
                RfNamedElement elem = LintUtils.getElementFromString(this.fOVMProject.getRfProject(), scope, issue.getOffset(), varName);
                if (elem == null || !(elem instanceof RfField) || !((RfField)elem).isParameter() && !elem.isConst() || !this.isNotAllowedValue(((RfField)elem).getInitialValue(false))) continue;
                int hitOffsetOnLine = this.getOffsetOnLine(document, issue);
                this.addHit(filename, issue.getLine(), this.getFailMessage(String.valueOf(prefix) + ((RfField)elem).getInitialValue(false), hitOffsetOnLine), issue.getReparseInfo(), new VerissimoAutofixAdditionalInfo(issue));
            }
        }
    }

    private boolean isNotAllowedValue(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("0|1step");
    }

    private DocumentManager getDocumentManager() {
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
        }
        catch (IllegalStateException illegalStateException) {}
        return docManager;
    }

    private int getOffsetOnLine(IDocument document, SVTBIssues issue) {
        int lineStartOffset = 0;
        int offsetOnLine = 0;
        try {
            lineStartOffset = document.getLineOffset(issue.getLine() - 1);
            offsetOnLine = issue.getOffset() - lineStartOffset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return offsetOnLine;
    }
}

