/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

@CheckVersion(value="16.1.4")
@CheckID(value="SVTB.10.7.3.0")
@CheckName(value="SVTB.10.7.3.0")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.DELAY})
@CheckTitle(value="Do not use #delay, ##delay, #1step")
@CheckDescription(value="Do not use #delay, ##delay, #1step\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_10_7_3_0
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="false", description="When true, only #delay, ##delay and #1step in design elements with time precision set will be flagged.", name="checkOnlyIfTimeprecisionIsSet", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyIfTimeprecisionIsSetValue;
    private static final Set<Class<? extends RfNamedElement>> TIME_PRECISION_CONTAINER_CLASSES = new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class, RfPackage.class, RfProgram.class));

    public Check_SVTB_10_7_3_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(105);
        aRfProject.lintTrackP2LInfo(130);
        aRfProject.lintTrackP2LInfo(37);
        aRfProject.lintTrackP2LInfo(44);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        String additionalInfo = issue.getMessageForHit();
        if (additionalInfo == null) {
            additionalInfo = "";
        }
        if (issue.getKind() == 105) {
            return String.valueOf(issue.getInfo()) + " used" + additionalInfo + "!";
        }
        return "#" + issue.getInfo() + " used" + additionalInfo + "!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        Map<ParserPath, List<SVTBIssues>> delayIssues = this.fOVMProject.getSVTBIssuesWithKind(130);
        Map<ParserPath, List<SVTBIssues>> cycleDelayIssues = this.fOVMProject.getSVTBIssuesWithKind(105);
        Map<Object, List<SVTBIssues>> issues = new HashMap<ParserPath, List<SVTBIssues>>();
        this.notifyCheckAlive();
        if ((delayIssues == null || delayIssues.isEmpty()) && (cycleDelayIssues == null || cycleDelayIssues.isEmpty())) {
            return issues;
        }
        if (cycleDelayIssues == null || cycleDelayIssues.isEmpty()) {
            issues.putAll(delayIssues);
        } else if (delayIssues == null || delayIssues.isEmpty()) {
            issues.putAll(LintUtils.removeCycleDelayIssuesInAssertions(this.fOVMProject.getRfProject(), cycleDelayIssues));
        } else {
            issues.putAll(delayIssues);
            cycleDelayIssues = LintUtils.removeCycleDelayIssuesInAssertions(this.fOVMProject.getRfProject(), cycleDelayIssues);
            for (Map.Entry<ParserPath, List<SVTBIssues>> cycleDelayIssue : cycleDelayIssues.entrySet()) {
                ParserPath key = cycleDelayIssue.getKey();
                if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(key, this)) continue;
                List<SVTBIssues> value = cycleDelayIssue.getValue();
                ArrayList values = (ArrayList)issues.get(key);
                if (values == null) {
                    values = new ArrayList();
                }
                values.addAll(value);
                issues.put(key, values);
            }
        }
        HashMap<ParserPath, List> tempIssues = new HashMap<ParserPath, List>();
        for (Map.Entry issue : issues.entrySet()) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived((ParserPath)issue.getKey(), this)) continue;
            tempIssues.put((ParserPath)issue.getKey(), (List)issue.getValue());
        }
        issues = tempIssues;
        if (this.pCheckOnlyIfTimeprecisionIsSetValue) {
            HashMap timePrecisionIssues = new HashMap();
            for (Map.Entry entry : issues.entrySet()) {
                ParserPath path = (ParserPath)entry.getKey();
                RfFileDef fileDefUsingParserPath = this.fOVMProject.getRfProject().getFileDefUsingParserPath(path);
                if (fileDefUsingParserPath == null) continue;
                this.notifyCheckAlive();
                ArrayList<SVTBIssues> timePrecisionIssuesList = new ArrayList<SVTBIssues>();
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    boolean checkProgram;
                    SVTBIssues issue = (SVTBIssues)iterator.next();
                    RfDefElement defScope = fileDefUsingParserPath.getScope(issue.getOffset(), true);
                    if (defScope == null) {
                        iterator.remove();
                        continue;
                    }
                    RfNamedElement scope = defScope.getNamedElement();
                    IRfNamedElement enclosingScope = scope.getEnclosingScope(TIME_PRECISION_CONTAINER_CLASSES);
                    if (enclosingScope == null) {
                        iterator.remove();
                        continue;
                    }
                    boolean checkModule = enclosingScope instanceof RfModule && ((RfModule)enclosingScope).hasDirectiveTimeprecision();
                    boolean checkPackage = enclosingScope instanceof RfPackage && ((RfPackage)enclosingScope).hasDirectiveTimeprecision();
                    boolean checkInterface = enclosingScope instanceof RfInterface && ((RfInterface)enclosingScope).hasDirectiveTimeprecision();
                    boolean bl = checkProgram = enclosingScope instanceof RfProgram && ((RfProgram)enclosingScope).hasDirectiveTimeprecision();
                    if (!checkModule && !checkPackage && !checkInterface && !checkProgram) continue;
                    int line = enclosingScope.getLine();
                    String linkPath = ((RfNamedElement)enclosingScope).getFile().getParserPath().path;
                    String elementKind = LintUtils.getElementKind((RfNamedElement)enclosingScope);
                    issue.setMessageForHit(", time precision set using timeprecision keyword in " + elementKind + " '" + LintUtils.getNamedElementFullName((RfNamedElement)enclosingScope) + "' " + this.link("declared at line " + line + " of " + LintUtils.getFileShortName(linkPath), linkPath, line));
                    timePrecisionIssuesList.add(issue);
                    iterator.remove();
                }
                if (timePrecisionIssuesList.isEmpty()) continue;
                timePrecisionIssues.put(path, timePrecisionIssuesList);
            }
            Map<ParserPath, List<SVTBIssues>> timescaleIssues = this.fOVMProject.getSVTBIssuesWithKind(37);
            if ((timescaleIssues == null || timescaleIssues.isEmpty()) && timePrecisionIssues.isEmpty()) {
                return Collections.emptyMap();
            }
            if (timescaleIssues != null && !timescaleIssues.isEmpty() && !issues.isEmpty()) {
                issues = this.computeIssuesAfterTimescale(timescaleIssues, issues);
            }
            if (!issues.isEmpty() && !timePrecisionIssues.isEmpty()) {
                for (Map.Entry entry : timePrecisionIssues.entrySet()) {
                    ParserPath path = (ParserPath)entry.getKey();
                    if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this)) continue;
                    List<SVTBIssues> issueList = issues.get(path);
                    if (issueList == null) {
                        issueList = new ArrayList<SVTBIssues>();
                    }
                    issueList.addAll((Collection)entry.getValue());
                    issues.put(path, issueList);
                }
            }
        }
        return issues;
    }

    private Map<ParserPath, List<SVTBIssues>> computeIssuesAfterTimescale(Map<ParserPath, List<SVTBIssues>> timescaleIssues, Map<ParserPath, List<SVTBIssues>> issues) {
        HashMap<ParserPath, List<SVTBIssues>> resultIssues = new HashMap<ParserPath, List<SVTBIssues>>();
        Map<ParserPath, List<SVTBIssues>> resetIssues = this.fOVMProject.getSVTBIssuesWithKind(44);
        VlogPreprocessingInfo preprocessingTable = this.fOVMProject.getRfProject().getPreprocessingTable();
        if (preprocessingTable == null) {
            return resultIssues;
        }
        VlogFileInstance vlogTopFile = preprocessingTable.getTopFileInstance();
        if (vlogTopFile == null) {
            return resultIssues;
        }
        List<VlogFileInstance> topFiles = vlogTopFile.getIncludedInstances();
        RfLibrary prevLibrary = null;
        boolean[] foundTimescale = new boolean[1];
        SVTBIssues[] foundTimescaleIssue = new SVTBIssues[1];
        ParserPath[] timescalePath = new ParserPath[1];
        for (VlogFileInstance topFile : topFiles) {
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(topFile.getParserPath());
            RfLibrary library = fileDef.getEnclosingLibrary();
            if (library == null) {
                library = this.getLibrary(topFile);
            }
            if (library != prevLibrary && prevLibrary != null) {
                foundTimescale[0] = false;
                foundTimescaleIssue[0] = null;
                timescalePath[0] = null;
            }
            this.notifyCheckAlive();
            this.searchFileForIssues(topFile, resultIssues, timescaleIssues, resetIssues, issues, foundTimescale, foundTimescaleIssue, timescalePath);
            prevLibrary = library;
        }
        return resultIssues;
    }

    private RfLibrary getLibrary(VlogFileInstance topFile) {
        List<VlogFileInstance> includedFiles = topFile.getIncludedInstances();
        for (VlogFileInstance includedFile : includedFiles) {
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(includedFile.getParserPath());
            RfLibrary library = fileDef.getEnclosingLibrary();
            if (library != null) {
                return library;
            }
            RfLibrary libraryOfIncluded = this.getLibrary(includedFile);
            if (libraryOfIncluded == null) continue;
            return libraryOfIncluded;
        }
        return null;
    }

    private void searchFileForIssues(VlogFileInstance fileInstance, Map<ParserPath, List<SVTBIssues>> resultIssues, Map<ParserPath, List<SVTBIssues>> timescaleIssues, Map<ParserPath, List<SVTBIssues>> resetIssues, Map<ParserPath, List<SVTBIssues>> issues, boolean[] foundTimescale, SVTBIssues[] previousFoundTimescaleIssue, ParserPath[] previousPath) {
        ParserPath path = fileInstance.getParserPath();
        List<SVTBIssues> timescaleIssuesForFile = timescaleIssues.get(path);
        List<SVTBIssues> resetIssuesForFile = resetIssues.get(path);
        List<SVTBIssues> delayIssuesForFile = issues.get(path);
        List<VlogFileInstance> includedFiles = fileInstance.getIncludedInstances();
        boolean previousFoundTimescale = foundTimescale[0];
        List<TimescaleInterval> intervals = this.getValidIntervals(timescaleIssuesForFile, resetIssuesForFile, previousFoundTimescale, previousFoundTimescaleIssue[0], previousPath[0], path);
        if (includedFiles != null && !includedFiles.isEmpty()) {
            for (VlogFileInstance includedFile : includedFiles) {
                int includingOffset = includedFile.getIncludingScope().getIncludingOffset();
                TimescaleInterval enclosingInterval = this.getEnclosingInterval(includingOffset, intervals);
                foundTimescale[0] = enclosingInterval != null;
                SVTBIssues sVTBIssues = previousFoundTimescaleIssue[0] = enclosingInterval == null ? null : enclosingInterval.getTimescaleIssueBeforeOffset(includingOffset);
                previousPath[0] = enclosingInterval == null ? null : (enclosingInterval.getTimescaleIssue().equals(enclosingInterval.getTimescaleIssueBeforeOffset(includingOffset)) ? enclosingInterval.getPath() : path);
                this.searchFileForIssues(includedFile, resultIssues, timescaleIssues, resetIssues, issues, foundTimescale, previousFoundTimescaleIssue, previousPath);
                if (enclosingInterval != null) {
                    if (foundTimescale[0]) continue;
                    this.shrinkInterval(includingOffset, intervals, timescaleIssuesForFile, path);
                    continue;
                }
                if (!foundTimescale[0]) continue;
                this.extendInterval(includingOffset, intervals, resetIssuesForFile, timescaleIssuesForFile, previousFoundTimescaleIssue[0], previousPath[0]);
            }
        }
        ArrayList<SVTBIssues> delayIssuesAfterTimescale = new ArrayList<SVTBIssues>();
        if (delayIssuesForFile != null && !delayIssuesForFile.isEmpty()) {
            for (SVTBIssues delayIssue : delayIssuesForFile) {
                for (TimescaleInterval interval : intervals) {
                    if (!interval.contains(delayIssue.getOffset())) continue;
                    SVTBIssues timescaleBeforeOffset = interval.getTimescaleIssueBeforeOffset(delayIssue.getOffset());
                    int line = 0;
                    String linkPath = "none";
                    if (timescaleBeforeOffset == interval.getTimescaleIssue()) {
                        line = interval.getTimescaleIssue().getLine();
                        linkPath = interval.getPath().path;
                    } else {
                        line = timescaleBeforeOffset.getLine();
                        linkPath = path.path;
                    }
                    delayIssue.setMessageForHit(", time precision set using `timescale directive " + this.link("at line " + line + " of " + LintUtils.getFileShortName(linkPath), linkPath, line));
                    delayIssuesAfterTimescale.add(delayIssue);
                }
            }
        }
        if (!delayIssuesAfterTimescale.isEmpty()) {
            resultIssues.put(path, delayIssuesAfterTimescale);
        }
        if (intervals != null && !intervals.isEmpty()) {
            TimescaleInterval lastInterval = intervals.get(intervals.size() - 1);
            int endOffset = lastInterval.getEnd();
            if (endOffset == -1) {
                foundTimescale[0] = true;
                List<SVTBIssues> localTimescaleIssues = lastInterval.getLocalTimescaleIssues();
                if (localTimescaleIssues == null || localTimescaleIssues.isEmpty()) {
                    previousFoundTimescaleIssue[0] = lastInterval.getTimescaleIssue();
                    previousPath[0] = lastInterval.getPath();
                } else {
                    previousFoundTimescaleIssue[0] = localTimescaleIssues.get(localTimescaleIssues.size() - 1);
                    previousPath[0] = path;
                }
            } else {
                foundTimescale[0] = false;
                previousFoundTimescaleIssue[0] = null;
                previousPath[0] = null;
            }
        }
    }

    private void extendInterval(int includingOffset, List<TimescaleInterval> intervals, List<SVTBIssues> resetIssuesForFile, List<SVTBIssues> timescaleIssuesForFile, SVTBIssues foundTimescaleIssue, ParserPath path) {
        TimescaleInterval foundInterval = null;
        for (TimescaleInterval interval : intervals) {
            if (interval.getStart() <= includingOffset) continue;
            foundInterval = interval;
            break;
        }
        SVTBIssues foundIssue = null;
        if (resetIssuesForFile != null) {
            for (SVTBIssues resetIssue : resetIssuesForFile) {
                if (resetIssue.getOffset() <= includingOffset) continue;
                foundIssue = resetIssue;
                break;
            }
        }
        if (foundInterval != null && foundIssue != null) {
            if (foundInterval.getStart() < foundIssue.getOffset()) {
                foundInterval.setStart(includingOffset);
                foundInterval.setPath(path);
                foundInterval.setTimescaleIssue(foundTimescaleIssue);
                this.setLocalIssuesForInterval(timescaleIssuesForFile, foundInterval);
            } else {
                newInterval = new TimescaleInterval(includingOffset, foundIssue.getOffset(), path, foundTimescaleIssue);
                this.setLocalIssuesForInterval(timescaleIssuesForFile, newInterval);
                intervals.add(newInterval);
            }
        } else if (foundIssue != null) {
            newInterval = new TimescaleInterval(includingOffset, foundIssue.getOffset(), path, foundTimescaleIssue);
            this.setLocalIssuesForInterval(timescaleIssuesForFile, newInterval);
            intervals.add(newInterval);
        } else if (foundInterval != null) {
            foundInterval.setStart(includingOffset);
            foundInterval.setPath(path);
            foundInterval.setTimescaleIssue(foundTimescaleIssue);
            this.setLocalIssuesForInterval(timescaleIssuesForFile, foundInterval);
        } else {
            newInterval = new TimescaleInterval(includingOffset, -1, path, foundTimescaleIssue);
            this.setLocalIssuesForInterval(timescaleIssuesForFile, newInterval);
            intervals.add(newInterval);
        }
    }

    private void setLocalIssuesForInterval(List<SVTBIssues> timescaleIssuesForFile, TimescaleInterval interval) {
        ArrayList<SVTBIssues> issuesForInterval = new ArrayList<SVTBIssues>();
        if (timescaleIssuesForFile == null) {
            interval.setLocalTimescaleIssues(issuesForInterval);
            return;
        }
        for (SVTBIssues timescaleIssue : timescaleIssuesForFile) {
            if (!interval.contains(timescaleIssue.getOffset())) continue;
            issuesForInterval.add(timescaleIssue);
        }
        interval.setLocalTimescaleIssues(issuesForInterval);
    }

    private void shrinkInterval(int includingOffset, List<TimescaleInterval> intervals, List<SVTBIssues> timescaleIssuesForFile, ParserPath currentPath) {
        int i = 0;
        while (i < intervals.size()) {
            TimescaleInterval interval = intervals.get(i);
            if (interval.contains(includingOffset)) {
                for (SVTBIssues timescaleIssue : timescaleIssuesForFile) {
                    if (!interval.contains(timescaleIssue.getOffset()) || includingOffset >= timescaleIssue.getOffset()) continue;
                    TimescaleInterval newInterval = new TimescaleInterval(timescaleIssue.getOffset(), interval.getEnd(), currentPath, timescaleIssue);
                    this.setLocalIssuesForInterval(timescaleIssuesForFile, newInterval);
                    intervals.add(i + 1, newInterval);
                    break;
                }
                interval.setEnd(includingOffset);
                this.setLocalIssuesForInterval(timescaleIssuesForFile, interval);
                break;
            }
            ++i;
        }
    }

    private TimescaleInterval getEnclosingInterval(int includingOffset, List<TimescaleInterval> intervals) {
        for (TimescaleInterval interval : intervals) {
            if (!interval.contains(includingOffset)) continue;
            return interval;
        }
        return null;
    }

    private List<TimescaleInterval> getValidIntervals(List<SVTBIssues> timescaleIssuesForFile, List<SVTBIssues> resetIssuesForFile, boolean previousFoundTimescale, SVTBIssues previousFoundTimescaleIssue, ParserPath previousPath, ParserPath currentPath) {
        TimescaleInterval interval;
        ArrayList<TimescaleInterval> result = new ArrayList<TimescaleInterval>();
        if ((timescaleIssuesForFile == null || timescaleIssuesForFile.isEmpty()) && (resetIssuesForFile == null || resetIssuesForFile.isEmpty())) {
            if (previousFoundTimescale) {
                result.add(new TimescaleInterval(-1, -1, previousPath, previousFoundTimescaleIssue));
            }
            return result;
        }
        ArrayList<SVTBIssues> allIssues = new ArrayList<SVTBIssues>();
        if (timescaleIssuesForFile != null) {
            allIssues.addAll(timescaleIssuesForFile);
        }
        if (resetIssuesForFile != null) {
            allIssues.addAll(resetIssuesForFile);
        }
        allIssues.sort(new Comparator<SVTBIssues>(){

            @Override
            public int compare(SVTBIssues o1, SVTBIssues o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return Integer.compare(o1.getOffset(), o2.getOffset());
            }
        });
        SVTBIssues previousIssue = null;
        SVTBIssues lastIssue = null;
        boolean foundEndOfPreviousFoundTimescale = false;
        ArrayList<SVTBIssues> timescaleIssues = new ArrayList<SVTBIssues>();
        Iterator iterator = allIssues.iterator();
        while (iterator.hasNext()) {
            SVTBIssues issue;
            lastIssue = issue = (SVTBIssues)iterator.next();
            if (issue.getKind() == 37) {
                timescaleIssues.add(issue);
            }
            if (previousIssue == null && previousFoundTimescale) {
                if (issue.getKind() != 44) continue;
                result.add(new TimescaleInterval(-1, issue.getOffset(), previousPath, previousFoundTimescaleIssue));
                foundEndOfPreviousFoundTimescale = true;
            }
            if (previousIssue != null && previousIssue.getKind() == issue.getKind()) continue;
            if (previousIssue != null && previousIssue.getKind() == 37 && issue.getKind() == 44) {
                TimescaleInterval interval2 = new TimescaleInterval(previousIssue.getOffset(), issue.getOffset(), currentPath, previousIssue);
                interval2.setLocalTimescaleIssues(timescaleIssues);
                result.add(interval2);
            }
            if (issue.getKind() == 44) {
                timescaleIssues.clear();
            }
            previousIssue = issue;
        }
        if (lastIssue != null && lastIssue.getKind() == 37) {
            if (previousIssue != null && previousIssue.getKind() == 37) {
                interval = new TimescaleInterval(previousIssue.getOffset(), -1, currentPath, lastIssue);
                interval.setLocalTimescaleIssues(timescaleIssues);
                result.add(interval);
            } else {
                interval = new TimescaleInterval(lastIssue.getOffset(), -1, currentPath, lastIssue);
                interval.setLocalTimescaleIssues(timescaleIssues);
                result.add(interval);
            }
        }
        if (previousFoundTimescale && !foundEndOfPreviousFoundTimescale) {
            result.clear();
            interval = new TimescaleInterval(-1, -1, previousPath, previousFoundTimescaleIssue);
            interval.setLocalTimescaleIssues(timescaleIssues);
            result.add(interval);
        }
        return result;
    }

    private static class TimescaleInterval {
        SVTBIssues timescaleIssue;
        ParserPath path;
        List<SVTBIssues> localTimescaleIssues;
        int start;
        int end;

        public TimescaleInterval(int start, int end, ParserPath path, SVTBIssues timescaleIssue) {
            this.start = start;
            this.end = end;
            this.path = path;
            this.timescaleIssue = timescaleIssue;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public boolean contains(int offset) {
            return this.start <= offset && (offset < this.end || this.end == -1);
        }

        public SVTBIssues getTimescaleIssue() {
            return this.timescaleIssue;
        }

        public SVTBIssues getTimescaleIssueBeforeOffset(int offset) {
            if (this.localTimescaleIssues == null || this.localTimescaleIssues.isEmpty()) {
                return this.timescaleIssue;
            }
            SVTBIssues result = this.timescaleIssue;
            for (SVTBIssues localIssue : this.localTimescaleIssues) {
                if (localIssue.getOffset() >= offset) continue;
                result = localIssue;
            }
            return result;
        }

        public void setTimescaleIssue(SVTBIssues timescaleIssue) {
            this.timescaleIssue = timescaleIssue;
        }

        public ParserPath getPath() {
            return this.path;
        }

        public void setPath(ParserPath path) {
            this.path = path;
        }

        public List<SVTBIssues> getLocalTimescaleIssues() {
            return this.localTimescaleIssues;
        }

        public void setLocalTimescaleIssues(List<SVTBIssues> localTimescaleIssues) {
            this.localTimescaleIssues = localTimescaleIssues;
        }
    }
}

