/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.11.2.1")
@CheckName(value="SVTB.11.2.1")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.LOOP})
@CheckTitle(value="Single Character Loop Iterators are forbidden")
@CheckDescription(value="It is difficult to search for a single character in a large loop.\nUse a descriptive name for the loop iterator where possible. Where not possible use a double character as the loop iterator.\n\nExamples:\n\nint cnt = 0;\nfor (int iterator = 0; iterator < 10; iterator++) begin // allowed\n\tcnt = cnt + 1;\nend\n\nfor (int i = 0; i < 10; i++) begin // not allowed\n\tcnt = cnt + 1;\nend\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_11_2_1
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_11_2_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(14);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Single character loop iterators used";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBIssuesWithKind(14);
    }
}

