/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Pair;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.22")
@CheckID(value="SVTB.11.2.2")
@CheckName(value="SVTB.11.2.2")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.LOOP, RuleLabel.ARRAY})
@CheckTitle(value="Underlying list modifications are forbidden in foreach loops")
@CheckDescription(value="Do not modify underlying list or the iterator in foreach loops. \n\n Example: pkg_1::class_2.class_3.function_4,[fixed_size_array].delete, [dynamic_array].delete, [associative_array].delete, [queue].delete\n\nCheck supports pre-waiving.")
public class Check_SVTB_11_2_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="[fixed_size_array].sort, [fixed_size_array].rsort, [fixed_size_array].shuffle, [fixed_size_array].reverse, [dynamic_array].delete, [dynamic_array].sort, [dynamic_array].rsort, [dynamic_array].shuffle, [dynamic_array].reverse, [associative_array].delete, [associative_array].sort, [associative_array].rsort, [associative_array].shuffle, [associative_array].reverse, [queue].delete, [queue].sort, [queue].rsort, [queue].shuffle, [queue].reverse, [queue].pop_back, [queue].pop_front, [queue].push_back, [queue].push_front ", description="Comma separated list of banned methods names.", name="bannedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedMethodsValue;
    @CheckParameter(defaultValue="true", description="When true, modifications followed by 'break' or 'return' are allowed.", name="allowModificationFollowedByBreakOrReturn", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowModificationFollowedByBreakOrReturnValue;

    public Check_SVTB_11_2_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement module : this.fOVMProject.getAllModules()) {
            this.performCheckOnScope(module);
        }
        for (RfNamedElement program : this.fOVMProject.getAllPrograms()) {
            this.performCheckOnScope(program);
        }
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            this.performCheckOnScope(function);
        }
        for (RfNamedElement task : this.fOVMProject.getAllTasks()) {
            this.performCheckOnScope(task);
        }
    }

    private void performCheckOnScope(RfNamedElement scope) {
        if (!scope.isPredefined()) {
            IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){
                private HashMap<RfNamedElement, ArrayList<Pair>> objects = new HashMap();

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    IHidObject lhValue;
                    if (!(namedElement instanceof RfActionBlock)) {
                        return true;
                    }
                    RfActionBlock actionBlock = (RfActionBlock)namedElement;
                    if ((actionBlock.getBlockQualifiers() & IRfActionBlockElement.BlockQualifier.FOREACH.value()) == 0L) {
                        return true;
                    }
                    Check_SVTB_11_2_2.this.notifyCheckAlive();
                    if (Check_SVTB_11_2_2.this.checkPreWaivers(namedElement.getFile())) {
                        return true;
                    }
                    List<IHidOperator> operators = actionBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_LOOP_EXPRESSION}, true);
                    if (operators == null || operators.isEmpty()) {
                        return true;
                    }
                    IHidOperator loopExpression = operators.get(0);
                    Hid listHid = null;
                    Hid parentHid = null;
                    int nOfIterators = 0;
                    if (loopExpression instanceof RfHidOperator && (lhValue = ((RfHidOperator)loopExpression).getLHValue()) instanceof RfHidAccess) {
                        listHid = ((RfHidAccess)lhValue).getParentHid();
                        if (listHid instanceof RfHid && ((RfHid)listHid).getParentAccess() != null) {
                            parentHid = ((RfHid)listHid).getParentAccess().getParentHid();
                        }
                        List selects = ((RfHidAccess)lhValue).getSelects();
                        for (IHidObject select : selects) {
                            if (select instanceof RfHidOperator) {
                                if (((RfHidOperator)select).getRHValues() == null) continue;
                                nOfIterators += ((RfHidOperator)select).getRHValues().size();
                                continue;
                            }
                            ++nOfIterators;
                        }
                    }
                    if (listHid == null || !HidUtils.isResolved(listHid)) {
                        return true;
                    }
                    this.objects.clear();
                    CheckForListModifications checkForListModif = new CheckForListModifications(listHid.getElement(), (IHid)parentHid, nOfIterators, this.objects);
                    actionBlock.visitHidObject(null, checkForListModif);
                    for (Map.Entry<RfNamedElement, ArrayList<Pair>> entry : this.objects.entrySet()) {
                        RfNamedElement modificationEnclosingScope = entry.getKey();
                        ArrayList<Pair> pairList = entry.getValue();
                        if (Check_SVTB_11_2_2.this.pAllowModificationFollowedByBreakOrReturnValue) {
                            Collections.sort(pairList, new Comparator<Pair>(){

                                @Override
                                public int compare(Pair o1, Pair o2) {
                                    return o1.hOcc.getOffset() - o2.hOcc.getOffset();
                                }
                            });
                            int result = Check_SVTB_11_2_2.this.isCoveredByReturnOrBreak(namedElement, modificationEnclosingScope);
                            if (result == 1) continue;
                            int i = 0;
                            while (i < pairList.size()) {
                                Check_SVTB_11_2_2.this.addHit(checkForListModif.getParserPath(), pairList.get((int)i).hOcc, pairList.get((int)i).message);
                                ++i;
                            }
                            continue;
                        }
                        for (Pair pair : pairList) {
                            Check_SVTB_11_2_2.this.addHit(checkForListModif.getParserPath(), pair.hOcc, pair.message);
                        }
                    }
                    return true;
                }
            };
            scope.accept(null, neVisitor);
        }
    }

    public int isCoveredByReturnOrBreak(RfNamedElement action, final RfNamedElement modificationEnclosingScope) {
        final int[] result = new int[1];
        action.visitHidObject(null, new IHidVisitor<IHidObject>(){
            RfNamedElement returnOperatorScope;

            public boolean visit(IHidObject hidObject) {
                if (!(hidObject instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator op = (RfHidOperator)hidObject;
                if (!op.isReturnStatement() && !op.isBreakStatement()) {
                    return true;
                }
                RfNamedElement initialEnclosingScope = modificationEnclosingScope;
                while (initialEnclosingScope instanceof RfActionBlock) {
                    if (initialEnclosingScope.equals(this.returnOperatorScope)) {
                        result[0] = 1;
                        return false;
                    }
                    initialEnclosingScope = initialEnclosingScope.getEnclosingScope();
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }

            public void setHolder(IHidHolder holder) {
                this.returnOperatorScope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }
        });
        return result[0];
    }

    private void addPairs(HashMap<RfNamedElement, ArrayList<Pair>> objects, RfNamedElement enclosingScope, HidOccurrence hodOccurence, String hitMessage) {
        ArrayList<Pair> occList = objects.get(enclosingScope);
        if (occList == null) {
            occList = new ArrayList();
        }
        occList.add(new Pair(hodOccurence, hitMessage));
        objects.put(enclosingScope, occList);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class CheckForListModifications
    implements IHidVisitor<IHidObject> {
        private IHidHolder holder;
        private ParserPath parserPath;
        private IRfNamedElement listElement;
        private IHid parentHid;
        private HashMap<RfNamedElement, ArrayList<Pair>> objects;
        private int nOfIterators;

        public CheckForListModifications(IRfNamedElement listElement, IHid parentHid, int nOfIterators, HashMap<RfNamedElement, ArrayList<Pair>> objects) {
            this.listElement = listElement;
            this.parentHid = parentHid;
            this.objects = objects;
            this.nOfIterators = nOfIterators;
        }

        public boolean visit(IHidObject hidObject) {
            RfNamedElement enclosingScope = (RfNamedElement)((RfHidHolder)this.holder).getScope();
            switch (hidObject.getHidKind()) {
                case OPERATOR: {
                    IRfNamedElement namedElement;
                    HidOperator hidOp = (HidOperator)hidObject;
                    if (!this.isOperator(hidOp.getOperatorText())) break;
                    IHidObject lhValue = hidOp.getLHValue();
                    if (lhValue instanceof RfHidAccess) {
                        List selects;
                        Hid list = ((RfHidAccess)lhValue).getParentHid();
                        if (list == null || !this.checkAccessToList(list, this.parentHid) || !this.listElement.equals(list.getElement()) || (selects = ((RfHidAccess)lhValue).getSelects()) != null && !selects.isEmpty() && selects.size() >= this.nOfIterators) break;
                        String hitMessage = "List '" + LintUtils.getNamedElementFullName((RfNamedElement)list.getElement()) + "' is modified by assignment while iterating!";
                        Check_SVTB_11_2_2.this.addPairs(this.objects, enclosingScope, (HidOccurrence)hidOp.getOccurrence(), hitMessage);
                        break;
                    }
                    if (!(lhValue instanceof RfHid) || !((namedElement = ((RfHid)lhValue).getElement()) instanceof RfNamedElement)) break;
                    if (namedElement instanceof RfNamedElement && ((RfNamedElement)namedElement).isImplicit()) {
                        HidOperatorOccurrence hidOcc = hidOp.getOccurrence();
                        Check_SVTB_11_2_2.this.addHit(this.parserPath, (HidOccurrence)hidOcc, "Iterator '" + LintUtils.getNamedElementFullName((RfNamedElement)namedElement) + "' is modified while iterating!");
                        break;
                    }
                    if (!this.listElement.equals(namedElement) || !this.checkAccessToList((RfHid)lhValue, this.parentHid)) break;
                    String hitMessage = "List '" + namedElement + "' is modified by assignment while iterating!";
                    Check_SVTB_11_2_2.this.addPairs(this.objects, enclosingScope, (HidOccurrence)hidOp.getOccurrence(), hitMessage);
                    break;
                }
                case HID: {
                    RfHid hid = (RfHid)hidObject;
                    IRfNamedElement namedElement = hid.getElement();
                    if (!(namedElement instanceof RfFunction)) break;
                    String calledFunctionFullName = LintUtils.getNamedElementFullName((RfFunction)namedElement);
                    if (!(enclosingScope instanceof RfActionBlock)) break;
                    if (namedElement instanceof RfPredefinedFunction) {
                        HidOccurrence hidOcc;
                        Hid list;
                        List selects;
                        HidAccess parentAccess;
                        if (!Check_SVTB_11_2_2.this.pBannedMethodsValue.contains(calledFunctionFullName) || (parentAccess = hid.getParentAccess()) == null || (selects = parentAccess.getSelects()) != null && !selects.isEmpty() && selects.size() >= this.nOfIterators || !HidUtils.isResolved((IHidObject)(list = parentAccess.getParentHid())) || !this.listElement.equals(list.getElement()) || !this.checkAccessToList(list, this.parentHid) || (hidOcc = hid.getOccurrence()) == null) break;
                        String hitMessage = "List '" + LintUtils.getNamedElementFullName((RfNamedElement)list.getElement()) + "' is modified by '" + LintUtils.getNamedElementFullName((RfNamedElement)namedElement) + "' while iterating!";
                        Check_SVTB_11_2_2.this.addPairs(this.objects, enclosingScope, hidOcc, hitMessage);
                        break;
                    }
                    if (!Check_SVTB_11_2_2.this.pBannedMethodsValue.contains(calledFunctionFullName)) break;
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                    if (methodCalls.isEmpty()) {
                        return true;
                    }
                    block4: for (MethodCall mCall : methodCalls) {
                        if (mCall.argumentValuesMap == null) continue;
                        for (Map.Entry argumentValue : mCall.argumentValuesMapRaw.entrySet()) {
                            IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                            if (!(key instanceof RfField) || ((RfField)key).isInput() || ((RfField)key).isConstRef()) continue;
                            IHidObject value = (IHidObject)argumentValue.getValue();
                            if (value instanceof RfHidAccess) {
                                List selects;
                                Hid list = ((RfHidAccess)value).getParentHid();
                                if (list == null || !this.listElement.equals(list.getElement()) || !this.checkAccessToList(list, this.parentHid) || (selects = ((RfHidAccess)value).getSelects()) != null && !selects.isEmpty() && selects.size() >= this.nOfIterators) continue block4;
                                String hitMessage = "List '" + LintUtils.getNamedElementFullName((RfNamedElement)list.getElement()) + "' is modified by '" + LintUtils.getNamedElementFullName((RfNamedElement)namedElement) + "' while iterating!";
                                Check_SVTB_11_2_2.this.addPairs(this.objects, enclosingScope, mCall.occurrence, hitMessage);
                                continue;
                            }
                            if (!(value instanceof RfHid) || !(value instanceof RfHid) || !((namedElement = ((RfHid)value).getElement()) instanceof RfNamedElement)) continue;
                            if (namedElement instanceof RfNamedElement && ((RfNamedElement)namedElement).isImplicit()) {
                                HidOccurrence hidOcc = mCall.occurrence;
                                Check_SVTB_11_2_2.this.addHit(this.parserPath, hidOcc, "Iterator '" + LintUtils.getNamedElementFullName((RfNamedElement)namedElement) + "' is modified while iterating!");
                                continue;
                            }
                            if (!this.listElement.equals(namedElement) || !this.checkAccessToList((RfHid)value, this.parentHid)) continue;
                            String hitMessage = "List '" + namedElement + "' is modified by assignment while iterating!";
                            Check_SVTB_11_2_2.this.addPairs(this.objects, enclosingScope, mCall.occurrence, hitMessage);
                        }
                    }
                    break;
                }
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        private boolean isOperator(String op) {
            switch (op) {
                case "=": {
                    return true;
                }
                case "+=": {
                    return true;
                }
                case "-=": {
                    return true;
                }
                case "*=": {
                    return true;
                }
                case "/=": {
                    return true;
                }
                case "++": {
                    return true;
                }
                case "--": {
                    return true;
                }
            }
            return false;
        }

        private boolean checkAccessToList(Hid list, IHid parentHid) {
            Hid accessToList = null;
            if (list.getParentAccess() != null) {
                accessToList = list.getParentAccess().getParentHid();
            }
            if (!HidUtils.isResolved((IHidObject)list)) {
                return false;
            }
            if (parentHid == null && accessToList != null) {
                return false;
            }
            if (parentHid != null && accessToList == null) {
                return false;
            }
            return parentHid == null || accessToList == null || parentHid.equals(accessToList);
        }
    }
}

