/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_11_2_2_3;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.39")
@CheckID(value="SVTB.11.2.2.3")
@CheckName(value="SVTB.11.2.2.3")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.LOOP, RuleLabel.FOR, RuleLabel.STYLING})
@CheckTitle(value="Prefer foreach loops instead of C-style for-loops when iterating over arrays")
@CheckDescription(value="When iterating over arrays is prefered to use foreach loops instead of C-style for-loops, this makes the code more readable.\nLoops starting from 0 to [dynamic_array].size() / [queue].size() / [associative_array].size() / [associative_array].num() incremented by 1 will be flagged.\n\nExample:\nint arr[];\nint q[$];\nint assoc_arr[*];\n\nfunction foo();\n\tfor (int i = 0; i < arr.size(); i++) // not allowed\n\t\tarr[i] = i;\n\n\tfor (int i = 0; i <= q.size() - 1; i += 1) // not allowed\n\t\tq[i] = 0;\n\n\tfor (int i = 0; assoc_arr.num() - 1 >= i; ++i) // not allowed\n\t\tassoc_arr[i] = 0;\n\n\tfor (int i = 0; assoc_arr.num() > i; i = i + 1) // not allowed\n\t\tassoc_arr[i] = 0;\nendfunction\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_11_2_2_3.class)
public class Check_SVTB_11_2_2_3
extends OVMComplianceCheck {
    private static final String SIZE = "size";
    private static final String NUM = "num";
    private static final String INITIALIZATION = "initialization";
    private static final String CONDITION = "condition";
    private static final String STEP = "step";
    private static final String ZERO = "0";
    private static final String ONE = "1";

    public Check_SVTB_11_2_2_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfActionBlock)) {
                    return true;
                }
                RfActionBlock loopActionBlock = (RfActionBlock)namedElement;
                if (!loopActionBlock.isFor()) {
                    return true;
                }
                Check_SVTB_11_2_2_3.this.notifyCheckAlive();
                if (Check_SVTB_11_2_2_3.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                RfHidHolder hidHolder = loopActionBlock.getHidHolder();
                if (hidHolder == null) {
                    return true;
                }
                if (hidHolder.getHidObjectsMap() == null) {
                    return true;
                }
                if (loopActionBlock.getDeclaration() == null) {
                    return true;
                }
                ParserPath loopDeclaration = loopActionBlock.getDeclaration().getParserPath();
                ListContainer loopOperators = (ListContainer)hidHolder.getHidObjectsMap().get(loopDeclaration);
                if (loopOperators == null || loopOperators.isEmpty()) {
                    return true;
                }
                HashMap loopElements = new HashMap();
                loopElements.put(Check_SVTB_11_2_2_3.INITIALIZATION, new HashSet());
                loopElements.put(Check_SVTB_11_2_2_3.CONDITION, new HashSet());
                loopElements.put(Check_SVTB_11_2_2_3.STEP, new HashSet());
                for (IHidObject operator : loopOperators) {
                    IHidObject left;
                    if (!(operator instanceof RfHidOperator)) continue;
                    if (((RfHidOperator)operator).isForInit()) {
                        left = ((RfHidOperator)operator).getLHValue();
                        if (!((Set)loopElements.get(Check_SVTB_11_2_2_3.CONDITION)).isEmpty()) continue;
                        ((Set)loopElements.get(Check_SVTB_11_2_2_3.INITIALIZATION)).add((RfHidOperator)left);
                        continue;
                    }
                    if (((RfHidOperator)operator).isForCondition()) {
                        ((Set)loopElements.get(Check_SVTB_11_2_2_3.CONDITION)).add((RfHidOperator)operator);
                        continue;
                    }
                    if (!((RfHidOperator)operator).isForStep()) continue;
                    left = ((RfHidOperator)operator).getLHValue();
                    if (((Set)loopElements.get(Check_SVTB_11_2_2_3.INITIALIZATION)).contains(left)) {
                        if (((Set)loopElements.get(Check_SVTB_11_2_2_3.CONDITION)).isEmpty()) continue;
                        ((Set)loopElements.get(Check_SVTB_11_2_2_3.INITIALIZATION)).remove(left);
                    }
                    if (((Set)loopElements.get(Check_SVTB_11_2_2_3.INITIALIZATION)).isEmpty() && ((Set)loopElements.get(Check_SVTB_11_2_2_3.CONDITION)).isEmpty()) continue;
                    ((Set)loopElements.get(Check_SVTB_11_2_2_3.STEP)).add((RfHidOperator)operator);
                }
                if (((Set)loopElements.get(Check_SVTB_11_2_2_3.INITIALIZATION)).size() != 1 || ((Set)loopElements.get(Check_SVTB_11_2_2_3.CONDITION)).size() != 1 || ((Set)loopElements.get(Check_SVTB_11_2_2_3.STEP)).size() != 1) {
                    return true;
                }
                RfHidOperator forInitialization = (RfHidOperator)((Set)loopElements.get(Check_SVTB_11_2_2_3.INITIALIZATION)).iterator().next();
                RfHidOperator forCondition = (RfHidOperator)((Set)loopElements.get(Check_SVTB_11_2_2_3.CONDITION)).iterator().next();
                RfHidOperator forStep = (RfHidOperator)((Set)loopElements.get(Check_SVTB_11_2_2_3.STEP)).iterator().next();
                if (forInitialization == null || forCondition == null || forStep == null) {
                    return true;
                }
                if (Check_SVTB_11_2_2_3.this.checkForElements(forInitialization, forCondition, forStep)) {
                    String initialization = HidUtils.toNiceString((IHidObject)forInitialization).replace("(", "").replace(")", "");
                    String condition = HidUtils.toNiceString((IHidObject)forCondition.getLHValue()).replace("(", "").replace(")", "");
                    String step = HidUtils.toNiceString((IHidObject)forStep.getLHValue()).replace("(", "").replace(")", "");
                    String forText = "for (" + initialization + "; " + condition + "; " + step + ")";
                    Check_SVTB_11_2_2_3.this.addHit(namedElement, "For-loop \"" + forText + "\" used instead of foreach!", new VerissimoAutofixAdditionalInfo(forCondition, loopActionBlock));
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private boolean checkForElements(RfHidOperator forInitialization, RfHidOperator forCondition, RfHidOperator forStep) {
        String forIteratorName = this.getName(forInitialization.getLHValue());
        if (forIteratorName.isEmpty()) {
            return false;
        }
        if (!this.checkForInitialization(forInitialization)) {
            return false;
        }
        if (!this.checkForCondition(forCondition, forIteratorName)) {
            return false;
        }
        return this.checkForStep(forStep, forIteratorName);
    }

    private boolean checkForInitialization(RfHidOperator forInitialization) {
        if (!forInitialization.isEqualAssignment()) {
            return false;
        }
        ListContainer rightValues = forInitialization.getRHValues();
        if (rightValues == null || rightValues.size() != 1) {
            return false;
        }
        IHidObject initialValue = (IHidObject)rightValues.get(0);
        if (!(initialValue instanceof RfHidImplicit)) {
            return false;
        }
        return ZERO.equals(((RfHidImplicit)initialValue).getName());
    }

    private boolean checkForCondition(RfHidOperator forCondition, String loopIteratorName) {
        if (!(forCondition.getLHValue() instanceof RfHidOperator)) {
            return false;
        }
        RfHidOperator forExpression = (RfHidOperator)forCondition.getLHValue();
        if (forExpression.getLHValue() == null || forExpression.getRHValues() == null || forExpression.getRHValues().size() != 1) {
            return false;
        }
        if (!forExpression.isRelational()) {
            return false;
        }
        IHidObject leftValue = forExpression.getLHValue();
        IHidObject rightValue = (IHidObject)forExpression.getRHValues().get(0);
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (loopIteratorName.equals(this.getName(leftValue))) {
            return this.checkConditionElements(forExpression, rightValue, true);
        }
        if (loopIteratorName.equals(this.getName(rightValue))) {
            return this.checkConditionElements(forExpression, leftValue, false);
        }
        return false;
    }

    private boolean checkConditionElements(RfHidOperator forCondition, IHidObject sizeFunction, boolean loopIteratorInLeftSide) {
        if (loopIteratorInLeftSide ? !forCondition.isLessThan() && !forCondition.isLessThanOrEqual() : !forCondition.isGreaterThan() && !forCondition.isGreaterThanOrEqual()) {
            return false;
        }
        if (forCondition.isLessThan() || forCondition.isGreaterThan()) {
            return this.isArraySizeFunction(sizeFunction);
        }
        if (forCondition.isLessThanOrEqual() || forCondition.isGreaterThanOrEqual()) {
            if (!(sizeFunction instanceof RfHidOperator)) {
                return false;
            }
            if (!((RfHidOperator)sizeFunction).isMinus()) {
                return false;
            }
            if (((RfHidOperator)sizeFunction).getLHValue() == null || ((RfHidOperator)sizeFunction).getRHValues() == null || ((RfHidOperator)sizeFunction).getRHValues().size() != 1) {
                return false;
            }
            IHidObject left = ((RfHidOperator)sizeFunction).getLHValue();
            IHidObject right = (IHidObject)((RfHidOperator)sizeFunction).getRHValues().get(0);
            if (left == null || right == null) {
                return false;
            }
            if (!this.isArraySizeFunction(left)) {
                return false;
            }
            if (!(right instanceof RfHidImplicit)) {
                return false;
            }
            return ONE.equals(((RfHidImplicit)right).getName());
        }
        return false;
    }

    private boolean checkForStep(RfHidOperator forStep, String varName) {
        if (!(forStep.getLHValue() instanceof RfHidOperator)) {
            return false;
        }
        RfHidOperator nextStep = (RfHidOperator)forStep.getLHValue();
        if (nextStep.isIncrement()) {
            IHidObject leftValue = nextStep.getLHValue();
            return varName.equals(this.getName(leftValue));
        }
        if (nextStep.isPlusEqual()) {
            if (nextStep.getLHValue() == null || nextStep.getRHValues() == null || nextStep.getRHValues().size() != 1) {
                return false;
            }
            IHidObject leftValue = nextStep.getLHValue();
            IHidObject rightValue = (IHidObject)nextStep.getRHValues().get(0);
            if (!varName.equals(this.getName(leftValue))) {
                return false;
            }
            if (!(rightValue instanceof RfHidImplicit)) {
                return false;
            }
            return ONE.equals(((RfHidImplicit)rightValue).getName());
        }
        if (nextStep.isEqualAssignment()) {
            if (nextStep.getLHValue() == null || nextStep.getRHValues() == null || nextStep.getRHValues().size() != 1) {
                return false;
            }
            IHidObject leftValue = nextStep.getLHValue();
            IHidObject rightValue = (IHidObject)nextStep.getRHValues().get(0);
            if (!varName.equals(this.getName(leftValue))) {
                return false;
            }
            if (!(rightValue instanceof RfHidOperator)) {
                return false;
            }
            if (!((RfHidOperator)rightValue).isPlus()) {
                return false;
            }
            IHidObject additionLeft = ((RfHidOperator)rightValue).getLHValue();
            IHidObject additionRight = (IHidObject)((RfHidOperator)rightValue).getRHValues().get(0);
            if (additionLeft instanceof RfHid && additionRight instanceof RfHidImplicit) {
                if (!varName.equals(this.getName(additionLeft))) {
                    return false;
                }
                return ONE.equals(((RfHidImplicit)additionRight).getName());
            }
            if (additionLeft instanceof RfHidImplicit && additionRight instanceof RfHid) {
                if (!varName.equals(this.getName(additionRight))) {
                    return false;
                }
                return ONE.equals(((RfHidImplicit)additionLeft).getName());
            }
        }
        return false;
    }

    private boolean isArraySizeFunction(IHidObject hidObject) {
        if (!(hidObject instanceof RfHidAccessArgs)) {
            return false;
        }
        Hid parentHid = ((RfHidAccessArgs)hidObject).getParentHid();
        if (parentHid == null) {
            return false;
        }
        IRfNamedElement function = parentHid.getElement();
        if (!(function instanceof RfPredefinedFunction)) {
            return false;
        }
        Hid parentParentHid = parentHid.getParentHid();
        if (parentParentHid == null) {
            return false;
        }
        IRfNamedElement array = parentParentHid.getElement();
        if (!(array instanceof RfField)) {
            return false;
        }
        IRfNamedElement arrayType = ((RfField)array).getAssociatedType();
        return SIZE.equals(function.getName()) && arrayType instanceof RfListType || NUM.equals(function.getName()) && ((RfListType)arrayType).isAssociativeArray();
    }

    private String getName(IHidObject hidObject) {
        if (!(hidObject instanceof IHid)) {
            return "";
        }
        return ((IHid)hidObject).getName();
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

