/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.11.2.8.1")
@CheckName(value="SVTB.11.2.8.1")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.LOOP})
@CheckTitle(value="Not Allowed: Jump Statements Outside of a Loop")
@CheckDescription(value="Jump statements must be in a loop. An always block is not a loop. This is not allowed:\nalways begin\n   if (foo == 5) begin\n     break;\n   end\nend\n\nCheck supports pre-waiving.")
public class Check_SVTB_11_2_8_1
extends OVMComplianceCheck {
    public Check_SVTB_11_2_8_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        rfProject.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                if (Check_SVTB_11_2_8_1.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                RfHidOperator opi = (RfHidOperator)operator;
                if (!opi.isBreakStatement() && !opi.isContinueStatement()) {
                    return true;
                }
                Check_SVTB_11_2_8_1.this.notifyCheckAlive();
                ISDataAbstract illegalUse = opi.getOperatorResolvedType();
                if (SDataUtils.isIllegalDataType((ISDataAbstract)illegalUse)) {
                    Check_SVTB_11_2_8_1.this.addHit(this.parserPath, (HidOccurrence)opi.getOccurrence(), "Jump statements outside of a loop found");
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

