/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.41")
@CheckID(value="SVTB.11.3")
@CheckName(value="SVTB.11.3")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CASE})
@CheckTitle(value="Case statements must have a default case item")
@CheckDescription(value="This ensures that if the case expression or items are changed, there's always a default branch to catch the unexpected values.\n\nExamples:\n\nint a;\nreg [1:0] address;\n\ncase (address) // allowed\n\t2'b00 : a = 1;\n\t2'b01, 2'b10 : a = 2;\n\tdefault : a = 3;\nendcase\n\ncase (address) // not allowed\n\t2'b00 : a = 4;\n\t2'b01, 2'b10 : a = 5;\nendcase\n\nCheck supports pre-waiving.")
public class Check_SVTB_11_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Allow missing default case item for fully specified enum case statements.", name="allowFullySpecifiedEnums", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowFullySpecifiedEnums;
    @CheckParameter(defaultValue="false", description="Allow missing default case item for fully specified variables.", name="allowFullySpecifiedVariables", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowFullySpecifiedVariables;
    private final Set<String> TWO_STATE_TYPES = new HashSet<String>(Arrays.asList("bit", "byte"));
    private final Set<String> FOUR_STATE_TYPES = new HashSet<String>(Arrays.asList("logic", "reg"));

    public Check_SVTB_11_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        if (actionBlocks == null) {
            return;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            this.notifyCheckAlive();
            if (!actionBlock.isCase() || actionBlock.isPriority() || actionBlock.isUnique() || actionBlock.isUnique0() || actionBlock.isRandCase() || this.checkPreWaivers(actionBlock.getFile())) continue;
            Collection<RfNamedElement> members = actionBlock.getMembers();
            if (members == null || members.isEmpty()) {
                this.addHit(actionBlock, "Case statement is missing the default case item!");
                continue;
            }
            final boolean[] foundDefaultCase = new boolean[]{false};
            for (RfNamedElement member : members) {
                if (!(member instanceof RfActionBlock) || !((RfActionBlock)member).isCaseItem() || !"default".equals(((RfActionBlock)member).getExpression())) continue;
                foundDefaultCase[0] = true;
            }
            if (foundDefaultCase[0]) continue;
            if (this.pAllowFullySpecifiedEnums) {
                actionBlock.visitHidObject(null, new IHidVisitor<RfHidOperator>(){
                    IRfNamedElement switchElement;
                    Set<String> enumValues;

                    public boolean visit(RfHidOperator hidOperator) {
                        if (this.enumValues != null && this.enumValues.isEmpty()) {
                            foundDefaultCase[0] = true;
                            return false;
                        }
                        if (hidOperator.isCaseCondition() && this.switchElement != null) {
                            return true;
                        }
                        if (hidOperator.isCaseCondition()) {
                            IHidObject lhValue = hidOperator.getLHValue();
                            if (!(lhValue instanceof RfHid)) {
                                return true;
                            }
                            IRfNamedElement switchElement = ((RfHid)lhValue).getElement();
                            if (!(switchElement instanceof RfField)) {
                                return true;
                            }
                            IRfNamedElement associatedType = ((RfField)switchElement).getAssociatedType();
                            if (!(associatedType instanceof RfTypeAlias)) {
                                return true;
                            }
                            RfNamedElement enumType = LintUtils.getAssociatedFinalType((RfTypeAlias)((RfField)switchElement).getAssociatedType());
                            if (!(enumType instanceof RfStruct)) {
                                return true;
                            }
                            if (!((RfStruct)enumType).isEnum()) {
                                return true;
                            }
                            Collection<IRfNamedElement> enumValues = ((RfStruct)enumType).getEnumValues();
                            if (enumValues == null) {
                                return false;
                            }
                            this.enumValues = new HashSet<String>();
                            enumValues.stream().forEach(e -> {
                                boolean bl = this.enumValues.add(e.getName());
                            });
                            this.switchElement = switchElement;
                            return true;
                        }
                        if (!hidOperator.isCaseItemCondition()) {
                            return true;
                        }
                        IHidObject lhValue = hidOperator.getLHValue();
                        if (!(lhValue instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement caseElement = ((RfHid)lhValue).getElement();
                        if (!(caseElement instanceof RfField)) {
                            return true;
                        }
                        if (!caseElement.equals(this.switchElement)) {
                            return true;
                        }
                        ListContainer rhValues = hidOperator.getRHValues();
                        if (rhValues == null || rhValues.isEmpty()) {
                            return true;
                        }
                        IHidObject caseItem = (IHidObject)rhValues.get(0);
                        if (!(caseItem instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement caseItemElement = ((RfHid)caseItem).getElement();
                        if (!(caseItemElement instanceof RfField)) {
                            return true;
                        }
                        if (!((RfField)caseItemElement).isEnumElement()) {
                            return true;
                        }
                        if (this.enumValues != null) {
                            this.enumValues.remove(caseItemElement.getName());
                        }
                        return true;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
            }
            if (this.pAllowFullySpecifiedVariables) {
                actionBlock.visitHidObject(null, new IHidVisitor<RfHidOperator>(){
                    IRfNamedElement switchElement;
                    Set<String> coveredStringItems;
                    Set<Integer> coveredNumberItems;
                    int possibilitiesStringItems = -1;
                    int possibilitiesNumberItems = -1;
                    int maxNumberValue = -1;

                    public boolean visit(RfHidOperator hidOperator) {
                        if (this.coveredNumberItems != null && this.possibilitiesNumberItems > 0) {
                            if (this.coveredStringItems != null && this.coveredNumberItems.size() == this.possibilitiesNumberItems && this.coveredStringItems.size() == this.possibilitiesStringItems) {
                                foundDefaultCase[0] = true;
                                return false;
                            }
                            if (this.possibilitiesStringItems == -1 && this.coveredNumberItems.size() == this.possibilitiesNumberItems) {
                                foundDefaultCase[0] = true;
                                return false;
                            }
                        }
                        if (hidOperator.isCaseCondition() && this.switchElement != null) {
                            return true;
                        }
                        if (hidOperator.isCaseCondition()) {
                            IHidObject lhValue = hidOperator.getLHValue();
                            if (!(lhValue instanceof RfHid) && !(lhValue instanceof RfHidAccess)) {
                                return true;
                            }
                            IRfNamedElement switchElement = null;
                            IRfNamedElement associatedType = null;
                            if (lhValue instanceof RfHid) {
                                switchElement = ((RfHid)lhValue).getElement();
                                if (!(switchElement instanceof RfField)) {
                                    return true;
                                }
                                associatedType = ((RfField)switchElement).getAssociatedType();
                            } else {
                                if (((RfHidAccess)lhValue).getParentHid() == null || ((RfHidAccess)lhValue).getParentHid().getElement() == null) {
                                    return true;
                                }
                                switchElement = ((RfHidAccess)lhValue).getParentHid().getElement();
                                if (!(switchElement instanceof RfField)) {
                                    return true;
                                }
                                associatedType = ((RfHidAccess)lhValue).getAssociatedType();
                            }
                            if (!(associatedType instanceof RfListType) && !(associatedType instanceof RfBitVectorScalarType)) {
                                return true;
                            }
                            if (associatedType instanceof RfListType) {
                                RfNamedElement finalType = LintUtils.getAssociatedFinalType((RfListType)associatedType);
                                if (!(finalType instanceof RfBitVectorScalarType)) {
                                    return true;
                                }
                                RfBitVectorScalarType arrayType = (RfBitVectorScalarType)finalType;
                                if (!Check_SVTB_11_3.this.TWO_STATE_TYPES.contains(arrayType.getName()) && !Check_SVTB_11_3.this.FOUR_STATE_TYPES.contains(arrayType.getName())) {
                                    return true;
                                }
                                DataType dataType = ((RfField)switchElement).getDataType();
                                if (dataType == null) {
                                    return true;
                                }
                                List<IndexType> packedDimensions = dataType.getPackedDimension();
                                if (packedDimensions == null) {
                                    return true;
                                }
                                for (IndexType dimension : packedDimensions) {
                                    RfHidOperator rangeOperator;
                                    IHidObject rangeObj = dimension.getRangeObject();
                                    if (!(rangeObj instanceof RfHidOperator) || !((RfHidOperator)rangeObj).getOperatorText().equals(":") || (rangeOperator = (RfHidOperator)rangeObj).getLHValue() == null || rangeOperator.getRHValues() == null || rangeOperator.getRHValues().isEmpty() || rangeOperator.getRHValues().size() > 1) continue;
                                    int leftValue = 0;
                                    int rightValue = 0;
                                    try {
                                        leftValue = Integer.valueOf(rangeOperator.getLHValue().toString());
                                        rightValue = Integer.valueOf(((IHidObject)rangeOperator.getRHValues().get(0)).toString());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        continue;
                                    }
                                    int size = 0;
                                    size = leftValue >= rightValue ? leftValue - rightValue + 1 : rightValue - leftValue + 1;
                                    if (Check_SVTB_11_3.this.FOUR_STATE_TYPES.contains(arrayType.getName())) {
                                        this.possibilitiesNumberItems = 1 << size;
                                        this.maxNumberValue = (1 << size) - 1;
                                        this.possibilitiesStringItems = (1 << size * 2) - this.possibilitiesNumberItems;
                                        continue;
                                    }
                                    this.possibilitiesNumberItems = 1 << size;
                                    this.maxNumberValue = (1 << size) - 1;
                                }
                            } else {
                                if (!Check_SVTB_11_3.this.TWO_STATE_TYPES.contains(associatedType.getName()) && !Check_SVTB_11_3.this.FOUR_STATE_TYPES.contains(associatedType.getName())) {
                                    return true;
                                }
                                if (Check_SVTB_11_3.this.FOUR_STATE_TYPES.contains(associatedType.getName())) {
                                    this.possibilitiesNumberItems = 2;
                                    this.possibilitiesStringItems = 2;
                                    this.maxNumberValue = 1;
                                } else if (associatedType.getName().equals("byte")) {
                                    this.possibilitiesNumberItems = 256;
                                    this.maxNumberValue = this.possibilitiesNumberItems - 1;
                                } else {
                                    this.possibilitiesNumberItems = 2;
                                    this.maxNumberValue = 1;
                                }
                            }
                            this.switchElement = switchElement;
                            return true;
                        }
                        if (!hidOperator.isCaseItemCondition()) {
                            return true;
                        }
                        IHidObject lhValue = hidOperator.getLHValue();
                        if (lhValue instanceof RfHidAccess) {
                            lhValue = ((RfHidAccess)lhValue).getParentHid();
                        }
                        if (!(lhValue instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement caseElement = ((RfHid)lhValue).getElement();
                        if (!(caseElement instanceof RfField)) {
                            return true;
                        }
                        if (!caseElement.equals(this.switchElement)) {
                            return true;
                        }
                        ListContainer rhValues = hidOperator.getRHValues();
                        if (rhValues == null || rhValues.isEmpty()) {
                            return true;
                        }
                        IHidObject caseItem = (IHidObject)rhValues.get(0);
                        if (!(caseItem instanceof RfHidImplicit)) {
                            return true;
                        }
                        RfHidImplicit caseItemImplicit = (RfHidImplicit)caseItem;
                        String caseItemString = caseItem.toString().toLowerCase();
                        if (caseItemString.contains("x") || caseItemString.contains("z")) {
                            if (this.coveredStringItems == null) {
                                this.coveredStringItems = new HashSet<String>();
                            }
                            if (caseItemString.contains("'")) {
                                caseItemString = caseItemString.substring(caseItemString.indexOf("'") + 1);
                            }
                            this.coveredStringItems.add(caseItemString);
                            return true;
                        }
                        Number number = caseItemImplicit.parseNumberValue();
                        if (!(number instanceof BigInteger)) {
                            return true;
                        }
                        if (number.intValue() > this.maxNumberValue) {
                            return true;
                        }
                        if (this.coveredNumberItems == null) {
                            this.coveredNumberItems = new HashSet<Integer>();
                        }
                        this.coveredNumberItems.add(number.intValue());
                        return true;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
            }
            if (foundDefaultCase[0]) continue;
            this.addHit(actionBlock, "Case statement is missing the default case item!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

