/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="19.1.17")
@CheckID(value="SVTB.11.4")
@CheckName(value="SVTB.11.4")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CASE})
@CheckTitle(value="Default case item must not be empty")
@CheckDescription(value="Default case item must not be empty.\n\nExamples:\n\nint a;\nreg [1:0] address;\n\ncase (address) // allowed\n\t2'b00 : a = 1;\n\t2'b01, 2'b10 : a = 2;\n\tdefault : a = 3;\nendcase\n\ncase (address) // not allowed\n\t2'b00 : a = 4;\n\t2'b01, 2'b10 : a = 5;\n\tdefault;\nendcase\n\nCheck supports pre-waiving.")
public class Check_SVTB_11_4
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="If true, default case items containing comments will be allowed.", name="allowComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowComments;

    public Check_SVTB_11_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(136);
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, List<SVTBIssues>> commentCharIssuesMap = this.fOVMProject.getSVTBCharIssuesWithKind(SVTBCharParser.Config.DEFAULT, 136, this);
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        if (actionBlocks == null) {
            return;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            Collection<RfNamedElement> members;
            this.notifyCheckAlive();
            if (!actionBlock.isCase() || this.checkPreWaivers(actionBlock.getFile()) || (members = actionBlock.getMembers()) == null || members.isEmpty()) continue;
            for (RfNamedElement member : members) {
                List<SVTBIssues> comments;
                RfFileDef file;
                if (!(member instanceof RfActionBlock) || !((RfActionBlock)member).isCaseItem() || !"default".equals(((RfActionBlock)member).getExpression())) continue;
                final boolean[] isEmpty = new boolean[]{true};
                member.visitHidObject(null, new IHidVisitor<IHidObject>(){

                    public boolean visit(IHidObject hidObject) {
                        if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isCaseItemCondition()) {
                            return true;
                        }
                        isEmpty[0] = false;
                        return false;
                    }

                    public Class<IHidObject> getType() {
                        return IHidObject.class;
                    }
                });
                if (isEmpty[0] && this.pAllowComments && commentCharIssuesMap != null && !commentCharIssuesMap.isEmpty() && (file = actionBlock.getFile()) != null && (comments = commentCharIssuesMap.get(file.getParserPath())) != null && comments.stream().anyMatch(c -> c.getLine() >= member.getLine() && c.getLine() <= member.getEndLine())) {
                    isEmpty[0] = false;
                }
                if (!isEmpty[0]) continue;
                this.addHit(member, "Default case item is empty!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

