/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.36")
@CheckID(value="SVTB.11.5")
@CheckName(value="SVTB.11.5")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CASE})
@CheckTitle(value="Case statements must not have more than one default case item")
@CheckDescription(value="Use of multiple default statements in one case statement is illegal according to the LRM\n\nExamples:\n\nint a;\nreg [1:0] address;\n\ncase (address) // allowed\n\t2'b00 : a = 1;\n\t2'b01, 2'b10 : a = 2;\n\tdefault : a = 3;\nendcase\n\ncase (address) // not allowed\n\t2'b00 : a = 4;\n\t2'b01, 2'b10 : a = 5;\n\tdefault : a = 6;\n\tdefault : a = 7;\nendcase\n\nCheck supports pre-waiving.")
public class Check_SVTB_11_5
extends OVMComplianceCheck {
    public Check_SVTB_11_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        if (actionBlocks == null) {
            return;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            Collection<RfNamedElement> members;
            RfFileDef fileDef;
            this.notifyCheckAlive();
            if (!actionBlock.isCase() || actionBlock.isRandCase() || (fileDef = actionBlock.getFile()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this) || (members = actionBlock.getMembers()) == null || members.isEmpty()) continue;
            int defaultItemNo = 0;
            String link = "";
            for (RfNamedElement member : members) {
                if (!(member instanceof RfActionBlock) || !((RfActionBlock)member).isCaseItem() || !"default".equals(((RfActionBlock)member).getExpression())) continue;
                int line = ((RfActionBlock)member).getLine();
                String file = ((RfActionBlock)member).getFile().getParserPath().path;
                link = String.valueOf(link) + "\n" + defaultItemNo + ": default " + this.link("at line " + line + " in file " + LintUtils.getFileShortName(file), file, line);
                ++defaultItemNo;
            }
            if (link.isEmpty() || defaultItemNo <= 1) continue;
            this.addHit(actionBlock, "Multiple default case items: " + link);
        }
    }
}

