/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.34")
@CheckID(value="SVTB.12.10")
@CheckName(value="SVTB.12.10")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.TASK, RuleLabel.DELAY, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not consume time in tasks assigning to an output argument")
@CheckDescription(value="Time consuming tasks assigning to an output argument should be avoided.\nThe arguments value is updated in the caller scope when the task ends. This isn't typically what the user expects.\n\nExample:\n\nint gV1;\nint gV2;\n\ntask timeConsumingTask(input int iV, output int oV);\n  gV1 = value;  // Updated immediately\n  #10;\n  \n  oV = value;\n  #10;\nendtask\n...\ntimeConsuminTask(10, gV2); // Updated after 20 (at the end of task call)")
public class Check_SVTB_12_10
extends OVMComplianceCheck {
    public Check_SVTB_12_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    private boolean recursiveFindDelayedTasks(final RfFunction function, final TasksInfoClass tasks) {
        if (tasks.delayedTasks.contains(function)) {
            return true;
        }
        function.visitHidObject(null, new IHidVisitor<IHidObject>(){
            IHidHolder holder;

            public void setHolder(IHidHolder holder) {
                this.holder = holder;
            }

            public void setParserPath(ParserPath parserPath) {
            }

            public boolean visit(IHidObject hidObject) {
                if (tasks.delayedTasks.contains(function)) {
                    return true;
                }
                if (hidObject.getHidKind() != IHidObject.HidKind.HID) {
                    return true;
                }
                RfHid hid = (RfHid)hidObject;
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                MethodCall methodCall = (MethodCall)methodCalls.remove(0);
                if (!(methodCall.method instanceof RfFunction)) {
                    return true;
                }
                RfFunction method = (RfFunction)methodCall.method;
                if (tasks.delayedTasks.contains(method)) {
                    if (!(this.holder instanceof RfHidHolder)) {
                        return true;
                    }
                    tasks.delayedTasks.add(function);
                    return true;
                }
                if (!tasks.visitedTasks.contains(method)) {
                    tasks.visitedTasks.add(method);
                    Check_SVTB_12_10.this.recursiveFindDelayedTasks(method, tasks);
                    if (tasks.delayedTasks.contains(method)) {
                        tasks.delayedTasks.add(function);
                    }
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        return tasks.delayedTasks.contains(function);
    }

    @Override
    public void performCheckImpl() {
        final TasksInfoClass tasks = new TasksInfoClass();
        RfProject rfProject = this.fOVMProject.getRfProject();
        RfFunction[] rfFunctionArray = rfProject.getAllFunctionsAndTasks();
        int n = rfFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            final RfFunction function = rfFunctionArray[n2];
            if (function.isTask()) {
                function.visitHidObject(rfProject, (IHidVisitor<?>)new HidOperatorVisitor(new HidOperatorQualifier[0]){
                    IHidHolder holder;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean visit(HidOperator operator) {
                        IRfNamedElement element;
                        if (!(operator instanceof RfHidOperator)) {
                            return true;
                        }
                        RfHidOperator hidOperator = (RfHidOperator)operator;
                        if (!hidOperator.isPound() && !hidOperator.isAssignment()) {
                            return true;
                        }
                        Check_SVTB_12_10.this.notifyCheckAlive();
                        if (!(this.holder instanceof RfHidHolder)) {
                            return true;
                        }
                        if (hidOperator.isPound()) {
                            tasks.delayedTasks.add(function);
                        }
                        if (!hidOperator.isAssignment()) return true;
                        IHidObject lhValue = hidOperator.getLHValue();
                        if (lhValue instanceof RfHid) {
                            element = ((RfHid)lhValue).getElement();
                        } else if (lhValue instanceof RfHidImplicit) {
                            element = ((RfHidImplicit)lhValue).getElement();
                        } else {
                            if (!(lhValue instanceof RfHidAccess)) return true;
                            Hid arrHid = ((RfHidAccess)lhValue).getParentHid();
                            if (!(arrHid instanceof RfHid)) return true;
                            element = ((RfHid)arrHid).getElement();
                        }
                        if (!(element instanceof RfField)) {
                            return true;
                        }
                        RfField field = (RfField)element;
                        if (!field.isOutput() && !field.isInout() || !field.isArgument()) return true;
                        tasks.outputAssignTasks.add(function);
                        return true;
                    }

                    public void setHolder(IHidHolder holder) {
                        this.holder = holder;
                    }
                });
            }
            ++n2;
        }
        for (final RfFunction function : tasks.outputAssignTasks) {
            tasks.visitedTasks.add(function);
            this.notifyCheckAlive();
            if (!this.recursiveFindDelayedTasks(function, tasks)) continue;
            this.addHit(function, "Time consuming task '" + LintUtils.getNamedElementFullName(function) + "' assigns a value to an output argument!");
        }
    }

    private static class TasksInfoClass {
        Set<RfFunction> delayedTasks = new HashSet<RfFunction>();
        Set<RfFunction> outputAssignTasks = new HashSet<RfFunction>();
        Set<RfFunction> visitedTasks = new HashSet<RfFunction>();
    }
}

