/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_12_11;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMultilineMethodDeclarationCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;

@CheckVersion(value="20.1.9")
@CheckID(value="SVTB.12.11")
@CheckName(value="SVTB.12.11")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="One argument per line")
@CheckDescription(value="Lines containing arguments of methods should not have more than <maxNofCharacters> characters.\nIf that number is exceeded then all of the arguments must be on a separate line and the arguments can not be on the same line as the method declaration.\n\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_12_11.class)
public class Check_SVTB_12_11
extends AbstractMultilineMethodDeclarationCheck {
    @CheckParameter(defaultValue="120", description="The maximum number of characters for which a method declaration may be written on a single line.", name="maxNofCharacters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private Integer pMaxNofCharacters;

    public Check_SVTB_12_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pMaxNofCharacters < 0) {
            this.signalParamError("Parameter 'maxNofCharacters' should be greater than or equal with 0!", true);
        }
    }

    @Override
    protected boolean checkDeclaration(ParserPath path, int declarationLine, ArrayList<RfFieldDef> arguments) {
        int totalLength = this.getTotalLength(path, declarationLine, arguments);
        return totalLength >= this.pMaxNofCharacters;
    }

    private int getTotalLength(ParserPath path, int declarationLine, ArrayList<RfFieldDef> arguments) {
        int result = 0;
        int lastLine = arguments.get(arguments.size() - 1).getStartLine();
        String lastLineAsString = this.numberOfCharactersCache.getLine(path, lastLine);
        if (lastLineAsString != null && !lastLineAsString.endsWith(");")) {
            result += ");".length();
        }
        int line = declarationLine;
        while (line <= lastLine) {
            result += this.numberOfCharactersCache.getNumberOfCharactersInLine(path, line).intValue();
            ++line;
        }
        return result;
    }

    @Override
    protected void analyzeArguments(ParserPath path, Map<Integer, ArrayList<RfFieldDef>> argumentsPerLine, RfDefElement declarationDefElement) {
        int declarationLine = declarationDefElement.getStartLine();
        for (Map.Entry<Integer, ArrayList<RfFieldDef>> entry : argumentsPerLine.entrySet()) {
            int line = entry.getKey();
            ArrayList<RfFieldDef> argumentsOnLine = entry.getValue();
            for (RfFieldDef argument : argumentsOnLine) {
                if (line != declarationLine && argumentsOnLine.size() > 1) {
                    this.addHit(argument.getParserPath(), line, "Argument '" + LintUtils.getNamedElementFullName(argument.getNamedElement()) + "' should not be on the same line as the other arguments!", null, new VerissimoAutofixAdditionalInfo(argument, argumentsOnLine));
                }
                if (line == declarationLine && argumentsOnLine.size() == 1) {
                    this.addHit(argument.getParserPath(), line, "Argument '" + LintUtils.getNamedElementFullName(argument.getNamedElement()) + "' should not be on the same line as the method declaration!", null, new VerissimoAutofixAdditionalInfo(argument, argumentsOnLine));
                    continue;
                }
                if (line != declarationLine || argumentsOnLine.size() <= 1) continue;
                this.addHit(argument.getParserPath(), line, "Argument '" + LintUtils.getNamedElementFullName(argument.getNamedElement()) + "' should not be on the same line as the method declaration and the other arguments!", null, new VerissimoAutofixAdditionalInfo(argument, argumentsOnLine));
            }
        }
    }
}

