/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_12_1_2;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.12.1.2")
@CheckName(value="SVTB.12.1.2")
@CheckLabel(labels={RuleLabel.METHOD})
@CheckTitle(value="Methods defined outside of classes must be explicitly declared automatic or static")
@CheckDescription(value="Methods defined outside of a class are by default static.\nMost users do not expect static storage from methods. This rule makes sure that they are getting what they want.\n\nExamples:\nclass a;\n  function f1(); endfunction // allowed\nendclass\n\nmodule top;\nfunction f2(); endfunction // not allowed\nfunction automatic f3(); endfunction // allowed\nfunction static f4(); endfunction // allowed\nendmodule\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_12_1_2.class)
public class Check_SVTB_12_1_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, methods that use the force assignment on an argument can be declared without using 'automatic' or 'static'", name="skipMethodsWithForceStatement", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    public Boolean pSkipMethodsWithForceStatement;
    @CheckParameter(defaultValue="false", description="When true, only methods explicitly declared automatic are allowed outside classes", name="allowOnlyAutomaticMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    public Boolean pAllowOnlyAutomaticMethods;

    public Check_SVTB_12_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        ArrayList<RfNamedElement> allMethods = new ArrayList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        NullProtectedList<RfFunction> allMethodsOutsideClasses = new NullProtectedList<RfFunction>();
        for (RfNamedElement methods : allMethods) {
            RfNamedElement container;
            if (this.checkPreWaivers(methods.getFile()) || (container = methods.getClosestTypeContainer()) instanceof RfClass) continue;
            this.notifyCheckAlive();
            allMethodsOutsideClasses.add((RfFunction)methods);
        }
        for (RfFunction method : allMethodsOutsideClasses) {
            if (method.isDPI() || method.isLet() || method.hasStorageStaticQualifier() && !this.pAllowOnlyAutomaticMethods.booleanValue() || method.hasStorageAutomaticQualifier()) continue;
            if (this.pSkipMethodsWithForceStatement.booleanValue()) {
                final boolean[] result = new boolean[1];
                final List<IRfFieldElement> arguments = method.getArguments();
                method.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                    /*
                     * Unable to fully structure code
                     */
                    public boolean visit(HidOperator hidOperator) {
                        if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_PROCEDURAL_FORCE_ASSIGN)) {
                            return true;
                        }
                        leftHid = hidOperator.getLHValue();
                        if (leftHid instanceof RfHidAccess) {
                            leftHid = ((RfHidAccess)leftHid).getParentHid();
                        }
                        if (leftHid instanceof RfHid) ** GOTO lbl9
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            leftHid = ((RfHid)leftHid).getParentHid();
lbl9:
                            // 2 sources

                            ** while (((RfHid)leftHid).getParentHid() instanceof RfHid)
                        }
lbl10:
                        // 1 sources

                        element = ((RfHid)leftHid).getElement();
                        if (!arguments.contains(element)) {
                            return true;
                        }
                        result[0] = true;
                        return false;
                    }
                });
                if (result[0]) continue;
            }
            this.addHit(method, String.valueOf(method.isTask() ? "Task '" : "Function '") + LintUtils.getNamedElementFullName(method) + "' is not declared " + (this.pAllowOnlyAutomaticMethods != false ? "" : "static or ") + "automatic!", new VerissimoAutofixAdditionalInfo(method));
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

