/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.39")
@CheckID(value="SVTB.12.2.10")
@CheckName(value="SVTB.12.2.10")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN, RuleLabel.CAST})
@CheckTitle(value="Do not cast to void function calls that return a value")
@CheckDescription(value="Do not cast to void function calls that return a value.\n\nExamples:\n\nfunction int f1();\n\treturn 1;\nendfunction\nfunction void f2(); endfunction \n\nfunction void test();\n\tvoid'(f1); // not allowed\n\tvoid'(f2); // allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_2_10
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of functions full names which are allowed to be casted to void.", name="allowedFunctions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedFunction;

    public Check_SVTB_12_2_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHidOperator>(){
            ParserPath parserPath;

            public boolean visit(RfHidOperator hidOperator) {
                if (!hidOperator.isVoidCast()) {
                    return true;
                }
                Check_SVTB_12_2_10.this.notifyCheckAlive();
                if (Check_SVTB_12_2_10.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                if (lhValue instanceof RfHidAccessArgs) {
                    lhValue = ((RfHidAccessArgs)lhValue).getParentHid();
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement function = ((RfHid)lhValue).getElement();
                if (!(function instanceof RfFunction)) {
                    return true;
                }
                if (((RfFunction)function).isTask()) {
                    return true;
                }
                if (Check_SVTB_12_2_10.this.pAllowedFunction.contains(((RfFunction)function).getFullName())) {
                    return true;
                }
                DataType dataType = ((RfFunction)function).getDataType();
                if (dataType != null && !"void".equals(dataType.getType())) {
                    Check_SVTB_12_2_10.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Non-void function call '" + LintUtils.getNamedElementFullName((RfFunction)function) + "()' is casted to void!");
                }
                return true;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

