/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.12.2.3")
@CheckName(value="SVTB.12.2.3")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN, RuleLabel.ASSIGNMENT})
@CheckTitle(value="Do not assign to the implicit function result variable")
@CheckDescription(value="Do not assign to the implicit function result variable in order to return a value.\nUse the more intuitive return construct to return a value.\n\nNot Allowed:\nfunction bit test;\n  test = 1'b1;\nendfunction: test\n\nAllowed:\nfunction bit test;\n  return(1'b1);\nendfunction: test")
public class Check_SVTB_12_2_3
extends OVMComplianceCheck {
    public Check_SVTB_12_2_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        CheckImplicitAssignment visitor = new CheckImplicitAssignment();
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            function.visitHidObject(null, visitor);
        }
    }

    private RfFunction getEnclosingFunction(RfNamedElement scope) {
        while (scope != null && !(scope instanceof RfFunction)) {
            scope = scope.getEnclosingScope();
        }
        if (scope != null && scope instanceof RfFunction && ((RfFunction)scope).isFunction()) {
            return (RfFunction)scope;
        }
        return null;
    }

    class CheckImplicitAssignment
    implements IHidVisitor<IHidObject> {
        protected IHidHolder holder;
        protected ParserPath parserPath;

        CheckImplicitAssignment() {
        }

        public boolean visit(IHidObject hidObject) {
            switch (hidObject.getHidKind()) {
                case OPERATOR: {
                    HidOperator hidOp = (HidOperator)hidObject;
                    if (!hidOp.hasOccurrence(HidQualifierCache.ALL_BLOCKING_ASSIGN_QUALIFIERS)) {
                        return true;
                    }
                    Check_SVTB_12_2_3.this.notifyCheckAlive();
                    IHidObject lhValue = hidOp.getLHValue();
                    if (!(lhValue instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement lhNamedElement = ((RfHid)lhValue).getElement();
                    RfFunction enclosingFunction = Check_SVTB_12_2_3.this.getEnclosingFunction((RfNamedElement)lhNamedElement);
                    if (enclosingFunction == null) {
                        return true;
                    }
                    if (lhNamedElement instanceof RfResultImplicitVariable) {
                        String enclosingFunctionFullName = LintUtils.getNamedElementFullName(enclosingFunction);
                        Check_SVTB_12_2_3.this.addHit(this.parserPath, (HidOccurrence)hidOp.getOccurrence(), "Implicit result variable assignment in: '" + enclosingFunctionFullName + "'!");
                    }
                    return true;
                }
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

