/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.5.35")
@CheckID(value="SVTB.12.2.3.1")
@CheckName(value="SVTB.12.2.3.1")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN, RuleLabel.ASSIGNMENT, RuleLabel.PREDEFINED_METHOD, RuleLabel.CAST})
@CheckTitle(value="Do not $cast to the implicit function result variable")
@CheckDescription(value="It is more intuitive to use an explicit return statement in order to return a value.\nAssigning to the implicit result variable should be avoided.")
public class Check_SVTB_12_2_3_1
extends OVMComplianceCheck {
    public Check_SVTB_12_2_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                Check_SVTB_12_2_3_1.this.notifyCheckAlive();
                if (namedElement instanceof RfFunction) {
                    RfFunction function = (RfFunction)namedElement;
                    List<RfFunctionCall> allCalls = function.getFunctionCallsWithPrefix("", 2);
                    if (allCalls == null || allCalls.isEmpty()) {
                        return true;
                    }
                    for (RfFunctionCall call : allCalls) {
                        String firstArg;
                        List<String> args;
                        String methodName;
                        boolean castCandidate;
                        boolean bl = castCandidate = call.getName().indexOf("$cast") > -1;
                        if (!castCandidate || !"$cast".equals(methodName = call.getFunctionName()) || (args = call.getArguments()) == null || args.isEmpty() || !(firstArg = args.get(0)).equals(function.getName())) continue;
                        Check_SVTB_12_2_3_1.this.addHit(call, "Not allowed $cast() to implicit result variable '" + function.getFullName() + "'!");
                    }
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }
}

