/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.12.2.7")
@CheckName(value="SVTB.12.2.7")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN, RuleLabel.CAST})
@CheckTitle(value="Function calls that return values cannot be disregarded without cast to void")
@CheckDescription(value="A call to a function that returns a value must assign the value.\nIf the value is not needed by the user then said user must cast the return value to void.\nExample:\nfunction bit myfunc;\n   return(1'b1);\nendfunction: myfunc\n...\nmyfunc(); // illegal - doesn't use the return value\nvoid'(myfunc()); // legal - casts away the return value\nmybit = myfunc(); // legal - assigns the return value\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_2_7
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, functions with type param accesses are also analyzed.", name="analyzeTypeParameterAccess", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAnalyzeTypeParameterAccessValue;
    @CheckParameter(defaultValue="", description="Specified methods will be skipped from checking.", name="skipMethodNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipFullMethodNames;
    @CheckParameter(defaultValue="false", description="When true, system functions and methods declared under +dvt_define will be skipped from checking.", name="skipSystemFunctions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipSystemFunctions;
    Set<String> skippedMethods = new HashSet<String>();

    public Check_SVTB_12_2_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (String methodName : this.pSkipFullMethodNames) {
            this.skippedMethods.add(methodName);
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new Visitor(this));
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class Visitor
    extends RfHidVisitor {
        private OVMComplianceCheck check;

        public Visitor(OVMComplianceCheck check) {
            this.check = check;
        }

        public boolean visit(RfHid hid) {
            HidOccurrence occurrence;
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                if (!Check_SVTB_12_2_7.this.pAnalyzeTypeParameterAccessValue) {
                    return true;
                }
                HidAccess parentAccess = hid.getParentAccess();
                if (parentAccess == null) {
                    return true;
                }
                RfHid parentHid = (RfHid)parentAccess.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement parentElement = parentHid.getElement();
                if (parentElement == null) {
                    return true;
                }
                IRfNamedElement parameter = null;
                if (parentElement instanceof RfField && ((RfField)parentElement).isTypeParameter()) {
                    parameter = parentElement;
                } else if (parentElement instanceof RfAssociatedType) {
                    parameter = ((RfAssociatedType)parentElement).getAssociatedTypeNoLastLevelParams();
                }
                if (parameter instanceof RfField && ((RfField)parameter).isTypeParameter()) {
                    IRfNamedElement scope;
                    IRfNamedElement tScope = scope = ((RfHidHolder)this.holder).getScope();
                    RfClass enclosingScope = (RfClass)scope.getEnclosingScope(RfClass.class);
                    if (enclosingScope != null) {
                        tScope = enclosingScope.getDefaultSpecialization(null);
                    }
                    RfHid copy = (RfHid)hid.getAncestorHid().deepCopy();
                    ConfigInfo configInfo = new ConfigInfo(false, Check_SVTB_12_2_7.this.fOVMProject.getRfProject(), null, true, null);
                    try {
                        copy.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), scope, scope, this.parserPath, RfTypesResolver.create((IRfScopeElement)tScope, Check_SVTB_12_2_7.this.fOVMProject.getRfProject(), 6), null, (byte)3, true, false, false);
                    }
                    catch (BuildCancelException e) {
                        Check_SVTB_12_2_7.this.fOVMProject.notifyCheckException(this.check, (Exception)((Object)e));
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    final boolean[] isResolved = new boolean[]{true};
                    copy.visitHidObject(Check_SVTB_12_2_7.this.fOVMProject.getRfProject(), new RfHidVisitor(){

                        public boolean visit(RfHid hidObject) {
                            if (!HidUtils.isResolved((IHidObject)hidObject)) {
                                isResolved[0] = false;
                                return false;
                            }
                            return true;
                        }
                    });
                    if (isResolved[0]) {
                        copy.visitHidObject(Check_SVTB_12_2_7.this.fOVMProject.getRfProject(), this);
                    }
                }
                return true;
            }
            if (!(element instanceof RfFunction)) {
                return true;
            }
            Check_SVTB_12_2_7.this.notifyCheckAlive();
            if (Check_SVTB_12_2_7.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (Check_SVTB_12_2_7.this.skippedMethods.contains(((RfFunction)element).getFullName())) {
                return true;
            }
            if (Check_SVTB_12_2_7.this.pSkipSystemFunctions && (element.isPredefined() || ((RfFunction)element).isUserDefinedSystemFunction())) {
                return true;
            }
            if (element instanceof RfPredefinedFunction && ("rand_mode".equals(element.getName()) || "constraint_mode".equals(element.getName()))) {
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                for (MethodCall methodCall : methodCalls) {
                    if (!methodCall.occurrence.hasQualifier(HidQualifierCache.STATEMENT_QUALIFIER) || methodCall.argumentValuesMapRaw != null && !methodCall.argumentValuesMapRaw.isEmpty()) continue;
                    Check_SVTB_12_2_7.this.addHit(this.parserPath, methodCall.occurrence, "Function call '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "()' return value is not assigned or casted to void!");
                }
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (function.isTask() || function.isConstructor()) {
                return true;
            }
            DataType dataType = function.getDataType();
            if (dataType != null && !"void".equals(dataType.getType()) && (occurrence = hid.getOccurrence()) != null) {
                if (!occurrence.hasQualifier(HidQualifierCache.STATEMENT_QUALIFIER)) {
                    return true;
                }
                Check_SVTB_12_2_7.this.addHit(this.parserPath, occurrence, "Function call '" + LintUtils.getNamedElementFullName(function) + "()' return value is not assigned or casted to void!");
            }
            return true;
        }
    }
}

