/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="16.1.30")
@CheckID(value="SVTB.12.2.8")
@CheckName(value="SVTB.12.2.8")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN})
@CheckTitle(value="Missing return in non-void functions")
@CheckDescription(value="A non-void function must always have a return statement.\nThe rule also checks if the implicit result value has been set before reaching a return without a value.\nIt checks that no matter how the code of a function is executed it will always reach a return statement.\nIt will flag functions that contain only if statements without else return statements, or case statements without default return statements even if the else or default statements are never reached.\n\nExamples:\n\nfunction int f1(); // allowed\n\tint a = 3;\n\treturn a;\nendfunction\n\nfunction int f2(); // not allowed\nendfunction\n\nfunction int f3(); // not allowed\n\tif (1)\n\t\treturn 0;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_2_8
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of method full names or macros used as an alternative to return statements (for example $finish).", name="alternativeReturns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pAlternativeReturnsValue;
    @CheckParameter(defaultValue="true", description="When true, virtual methods will be ignored.", name="skipVirtualMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    public Boolean pSkipVirtualMethods;
    private final HashSet<String> fMacroCalls = new HashSet();
    private final HashSet<String> fAllowedFunctionsAsReturn = new HashSet();
    private static final HidOperatorQualifier[] CASE_ITEMS = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION};

    public Check_SVTB_12_2_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String aReturn : this.pAlternativeReturnsValue) {
            if (aReturn.startsWith("`")) {
                this.fMacroCalls.add(aReturn);
                continue;
            }
            this.fAllowedFunctionsAsReturn.add(aReturn);
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("all", this.fMacroCalls);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            List<RfActionBlock> actionBlocks;
            RfDefElement implementation;
            RfDefElement declaration;
            if (!(function instanceof RfFunction) || ((RfFunction)function).isConstructor() || this.pSkipVirtualMethods.booleanValue() && ((RfFunction)function).isVirtual() || ((RfFunction)function).isVoid() || ((RfFunction)function).isLet() || (declaration = function.getDeclaration()) != null && ((RfFunctionDef)declaration).isPrototype()) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(function.getFile()) || (implementation = function.getImplementation()) == null) continue;
            RfFileDef defFile = implementation.getDefFile();
            MacroCallInfo macroCallInfo = ((RfFunction)function).getMacroCallInfo();
            List<MacroCallItem> macroCallItems = LintUtils.getMacroCallsInSet(macroCallInfo, this.fMacroCalls);
            TreeMap<Integer, MacroCallItem> macroCallsHeap = new TreeMap<Integer, MacroCallItem>();
            if (macroCallItems != null) {
                for (MacroCallItem m : macroCallItems) {
                    macroCallsHeap.put(m.getLineInfo().realOffset, m);
                }
            }
            Node root = new Node(null, null, null, BlockType.IS_EMPTY, false);
            this.findAlternativeReturns(function, root, macroCallsHeap, defFile);
            RfHidHolder hidHolder = function.getHidHolder();
            if (hidHolder != null) {
                this.visitActionBlock(root, function, hidHolder);
            }
            if ((actionBlocks = function.getLocalMembers(RfActionBlock.class)) != null && !actionBlocks.isEmpty()) {
                for (RfActionBlock actionBlock : actionBlocks) {
                    if (actionBlock.getStartOffset() == actionBlock.getEndOffset() && (declaration == null || actionBlock.getDeclaration() == null || actionBlock.getDeclaration().getReparseInfo() == null || actionBlock.getDeclaration().getReparseInfo().equals(declaration.getReparseInfo()))) continue;
                    this.constructTree(root, actionBlock, function, macroCallsHeap, defFile);
                }
            }
            if (root.getType() == BlockType.HAS_ASSIGN_RETURN || root.getType() == BlockType.HAS_NON_VOID_RETURN) {
                this.propagateResultsFromChildToRoot(root, function);
                continue;
            }
            if ((actionBlocks == null || actionBlocks.isEmpty()) && root.getType() == BlockType.IS_EMPTY) {
                this.addHit(function, "Function can exit without returning an explicit result!");
                continue;
            }
            if ((actionBlocks == null || actionBlocks.isEmpty()) && root.getType() == BlockType.HAS_VOID_RETURN) {
                this.addHit(function, "Function can exit without returning an explicit result!");
                this.addHit(function.getDeclaration().getParserPath(), root.getHidOccurrence(), "No function value set before reaching return statement!");
                continue;
            }
            if (actionBlocks == null || actionBlocks.isEmpty()) continue;
            boolean result = this.propagateResultsFromChildToRoot(root, function);
            boolean hasIndependentBlock = false;
            block3: for (Node child : root.getChildren()) {
                if (child.getActionBlock().isElse() || child.getActionBlock().isSimpleBeginEnd() || this.isIndependentWhileLoop(child.getActionBlock())) {
                    hasIndependentBlock = true;
                    break;
                }
                if (!child.getActionBlock().isCase()) continue;
                for (Node nephew : child.getChildren()) {
                    if (!this.isDefaultCaseBlock(nephew.getActionBlock())) continue;
                    hasIndependentBlock = true;
                    continue block3;
                }
            }
            if (root.getHasInfiniteLoopWithReturn() || result) continue;
            if (root.getType() == BlockType.HAS_VOID_RETURN) {
                this.addHit(function, "Function can exit without returning an explicit result!");
                continue;
            }
            if (!hasIndependentBlock && root.getType() == BlockType.IS_EMPTY) {
                this.addHit(function, "Function can exit without returning an explicit result!");
                continue;
            }
            if (root.getType() != BlockType.IS_EMPTY) continue;
            int numberOfTabs = 0;
            String path = this.printPath(root, root, numberOfTabs);
            if (path.contains("return")) {
                path = path.substring(0, path.length() - 6);
            }
            if (path != null && path.length() > 0) {
                this.addHit(function, "Function can exit without returning an explicit result! Possible path:\n" + path);
                continue;
            }
            this.addHit(function, "Function can exit without returning an explicit result!");
        }
    }

    public void constructTree(Node parent, RfActionBlock actionBlock, RfNamedElement function, TreeMap<Integer, MacroCallItem> macroCallsHeap, RfFileDef defFile) {
        Node currentNode = new Node(parent, actionBlock, null, BlockType.IS_EMPTY, parent.getHasInfiniteLoopWithReturn());
        this.findAlternativeReturns(actionBlock, currentNode, macroCallsHeap, defFile);
        RfHidHolder hidHolder = currentNode.getActionBlock().getHidHolder();
        if (actionBlock.isConditional() || actionBlock.isLoop() || actionBlock.isSimpleBeginEnd()) {
            if (hidHolder != null) {
                this.visitActionBlock(currentNode, function, hidHolder);
            }
            parent.addChild(currentNode);
        } else if (actionBlock.isCaseItem()) {
            if (hidHolder != null) {
                this.visitActionBlock(currentNode, function, hidHolder);
            }
            parent.addChild(currentNode);
        } else if (actionBlock.isCase()) {
            parent.addChild(currentNode);
        }
        List<RfActionBlock> actionBlocks = actionBlock.getLocalMembers(RfActionBlock.class);
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return;
        }
        for (RfActionBlock a : actionBlocks) {
            if (a.getStartOffset() == a.getEndOffset()) continue;
            this.constructTree(currentNode, a, function, macroCallsHeap, defFile);
        }
    }

    private void findAlternativeReturns(RfNamedElement actionBlock, Node currentNode, TreeMap<Integer, MacroCallItem> macroCallsHeap, RfFileDef defFile) {
        if (this.fMacroCalls.isEmpty()) {
            return;
        }
        int startOffset = actionBlock.getStartOffset();
        int endOffset = actionBlock.getEndOffset();
        Map.Entry<Integer, MacroCallItem> macroCall = macroCallsHeap.ceilingEntry(startOffset);
        while (macroCall != null && macroCall.getKey() <= endOffset) {
            RfNamedElement macroCallEnclosingScope;
            RfDefElement scope = defFile.getScope(macroCall.getValue().getLineInfo().realOffset, true);
            if (this.fMacroCalls.contains(macroCall.getValue().getName()) && (macroCallEnclosingScope = scope.getNamedElement()) != null) {
                while (macroCallEnclosingScope.getStartOffset() == macroCallEnclosingScope.getEndOffset()) {
                    macroCallEnclosingScope = macroCallEnclosingScope.getEnclosingScope();
                }
                if (macroCallEnclosingScope.equals(actionBlock)) {
                    currentNode.setType(BlockType.HAS_NON_VOID_RETURN);
                    currentNode.setHidOccurrence(new HidOccurrence(macroCall.getValue().getLineInfo().realOffset, -1, macroCall.getValue().getLineNumber(), 0L, null));
                    break;
                }
            }
            macroCall = macroCallsHeap.ceilingEntry(macroCall.getKey() + 1);
        }
    }

    public void visitActionBlock(final Node node, final RfNamedElement function, RfHidHolder hidHolder) {
        hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidObject>(){
            private static volatile /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind;

            /*
             * Unable to fully structure code
             */
            public boolean visit(IHidObject hidObject) {
                switch (1.$SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind()[hidObject.getHidKind().ordinal()]) {
                    case 4: {
                        hidOp = (RfHidOperator)hidObject;
                        if (hidOp.isReturnStatement()) {
                            rhValue = (IHidObject)hidOp.getRHValues().get(0);
                            type = node.getType();
                            if (!(rhValue instanceof RfHidImplicit)) {
                                if (type != BlockType.IS_EMPTY) {
                                    if (Check_SVTB_12_2_8.this.isSetBefore((HidOccurrence)hidOp.getOccurrence(), node.getHidOccurrence())) {
                                        node.setType(BlockType.HAS_NON_VOID_RETURN);
                                        node.setHidOccurrence((HidOccurrence)hidOp.getOccurrence());
                                    }
                                } else {
                                    node.setType(BlockType.HAS_NON_VOID_RETURN);
                                    node.setHidOccurrence((HidOccurrence)hidOp.getOccurrence());
                                }
                                return true;
                            }
                            if (((RfHidImplicit)rhValue).isEmptyJump()) {
                                if (type != BlockType.IS_EMPTY) {
                                    if (Check_SVTB_12_2_8.this.isSetBefore((HidOccurrence)hidOp.getOccurrence(), node.getHidOccurrence())) {
                                        node.setType(BlockType.HAS_VOID_RETURN);
                                        node.setHidOccurrence((HidOccurrence)hidOp.getOccurrence());
                                    }
                                } else {
                                    node.setType(BlockType.HAS_VOID_RETURN);
                                    node.setHidOccurrence((HidOccurrence)hidOp.getOccurrence());
                                }
                                return true;
                            }
                            node.setType(BlockType.HAS_NON_VOID_RETURN);
                            node.setHidOccurrence((HidOccurrence)hidOp.getOccurrence());
                            return true;
                        }
                        if (!hidOp.isEqualAssignment()) ** GOTO lbl43
                        lhValue = hidOp.getLHValue();
                        type = node.getType();
                        if (!(lhValue instanceof RfHidAccess) || ((RfHidAccess)lhValue).getParentHid() == null || !((RfHidAccess)lhValue).getParentHid().getName().equals(function.getName())) ** GOTO lbl41
                        this.updateHasAssignReturn(node, hidOp, type);
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            if (!(lhValue instanceof RfHid)) {
                                return true;
                            }
                            lhHid = (RfHid)lhValue;
                            if (lhHid.getName().equals(function.getName())) {
                                this.updateHasAssignReturn(node, hidOp, type);
                                return true;
                            }
                            lhValue = lhHid.getParentHid();
lbl41:
                            // 2 sources

                            ** while (lhValue != null)
                        }
lbl42:
                        // 1 sources

                        return true;
lbl43:
                        // 1 sources

                        return true;
                    }
                    case 1: {
                        type = node.getType();
                        hid = (RfHid)hidObject;
                        if (hid.getElement() instanceof RfFunction) {
                            startOffset = ((RfFunction)hid.getElement()).getStartOffset();
                            line = ((RfFunction)hid.getElement()).getLine();
                            hidOccurrence = new HidOccurrence(startOffset, -1, line, 0L, null);
                            if (hid.getElement() instanceof RfPredefinedFunction) {
                                if (Check_SVTB_12_2_8.this.fAllowedFunctionsAsReturn.contains(hid.getElement().getName())) {
                                    if (type != BlockType.IS_EMPTY) {
                                        if (Check_SVTB_12_2_8.this.isSetBefore(hidOccurrence, node.getHidOccurrence())) {
                                            node.setType(BlockType.HAS_NON_VOID_RETURN);
                                            node.setHidOccurrence(hidOccurrence);
                                        }
                                    } else {
                                        node.setType(BlockType.HAS_NON_VOID_RETURN);
                                        node.setHidOccurrence(hidOccurrence);
                                    }
                                    return true;
                                }
                            } else if (Check_SVTB_12_2_8.this.fAllowedFunctionsAsReturn.contains(LintUtils.getNamedElementFullName((RfNamedElement)hid.getElement()))) {
                                if (type != BlockType.IS_EMPTY) {
                                    if (Check_SVTB_12_2_8.this.isSetBefore(hidOccurrence, node.getHidOccurrence())) {
                                        node.setType(BlockType.HAS_NON_VOID_RETURN);
                                        node.setHidOccurrence(hidOccurrence);
                                    }
                                } else {
                                    node.setType(BlockType.HAS_NON_VOID_RETURN);
                                    node.setHidOccurrence(hidOccurrence);
                                }
                                return true;
                            }
                        }
                        if (!hid.isMethodCall(false)) {
                            return true;
                        }
                        methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                        if (methodCalls.isEmpty()) {
                            return true;
                        }
                        if (hid.getName().equals("$cast")) {
                            for (MethodCall methodCall : methodCalls) {
                                if (methodCall.argumentValuesMap == null) continue;
                                for (Map.Entry<K, V> argumentValue : methodCall.argumentValuesMap.entrySet()) {
                                    if (!(argumentValue.getKey() instanceof RfPredefinedField) || !(field = (RfPredefinedField)argumentValue.getKey()).getName().equals("dest_var") || (castDestinationHids = (Set)argumentValue.getValue()) == null || castDestinationHids.isEmpty()) continue;
                                    for (IHid castDestinationHid : castDestinationHids) {
                                        if (!(castDestinationHid instanceof RfHid) || !(castDestination = ((RfHid)castDestinationHid).getElement()).getName().equals(function.getName())) continue;
                                        if (type != BlockType.IS_EMPTY) {
                                            if (Check_SVTB_12_2_8.this.isSetBefore(methodCall.occurrence, node.getHidOccurrence())) {
                                                node.setType(BlockType.HAS_ASSIGN_RETURN);
                                                node.setHidOccurrence(methodCall.occurrence);
                                            }
                                        } else {
                                            node.setType(BlockType.HAS_ASSIGN_RETURN);
                                            node.setHidOccurrence(methodCall.occurrence);
                                        }
                                        return true;
                                    }
                                }
                            }
                        }
                        for (MethodCall methodCall : methodCalls) {
                            if (methodCall.argumentValuesMap == null) continue;
                            for (Map.Entry<K, V> argumentValue : methodCall.argumentValuesMap.entrySet()) {
                                if (!(argumentValue.getKey() instanceof RfField)) continue;
                                argument = (RfField)argumentValue.getKey();
                                values = (Set)argumentValue.getValue();
                                if (values == null || values.isEmpty() || (element = (auxHid = (IHid)values.iterator().next()).getElement()) == null || argument.isInput() || argument.isConstRef() || !argument.isOutput() && !argument.isInout() && !argument.isRef() || !element.getName().equals(function.getName())) continue;
                                if (type != BlockType.IS_EMPTY) {
                                    if (Check_SVTB_12_2_8.this.isSetBefore(methodCall.occurrence, node.getHidOccurrence())) {
                                        node.setType(BlockType.HAS_ASSIGN_RETURN);
                                        node.setHidOccurrence(methodCall.occurrence);
                                    }
                                } else {
                                    node.setType(BlockType.HAS_ASSIGN_RETURN);
                                    node.setHidOccurrence(methodCall.occurrence);
                                }
                                return true;
                            }
                        }
                        return true;
                    }
                }
                return true;
            }

            private void updateHasAssignReturn(Node node2, RfHidOperator hidOp, BlockType type) {
                if (type != BlockType.IS_EMPTY) {
                    if (Check_SVTB_12_2_8.this.isSetBefore((HidOccurrence)hidOp.getOccurrence(), node2.getHidOccurrence())) {
                        node2.setType(BlockType.HAS_ASSIGN_RETURN);
                        node2.setHidOccurrence((HidOccurrence)hidOp.getOccurrence());
                    }
                } else {
                    node2.setType(BlockType.HAS_ASSIGN_RETURN);
                    node2.setHidOccurrence((HidOccurrence)hidOp.getOccurrence());
                }
            }

            public void setHolder(IHidHolder holder) {
            }

            public void setParserPath(ParserPath parserPath) {
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }

            static /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind() {
                if ($SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind != null) {
                    return $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind;
                }
                int[] nArray = new int[IHidObject.HidKind.values().length];
                try {
                    nArray[IHidObject.HidKind.ACCESS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.HID.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.HOLDER.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.IMPLICIT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.OPERATOR.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind = nArray;
                return nArray;
            }
        });
    }

    public boolean propagateResultsFromChildToRoot(Node node, RfNamedElement function) {
        boolean allChildsHaveValidReturns = true;
        boolean isConsideredAssingBlock = true;
        boolean hasIndependentBlock = false;
        List<Node> childs = node.getChildren();
        if (childs.isEmpty()) {
            int aux = this.getNodeType(node, function);
            if (aux == 0) {
                return false;
            }
            if (aux == 1) {
                return true;
            }
        }
        for (Node child : childs) {
            boolean aux = this.propagateResultsFromChildToRoot(child, function);
            if (!aux) {
                allChildsHaveValidReturns = false;
            }
            if (!child.getHasInfiniteLoopWithReturn()) continue;
            node.setHasInfiteLoopWithReturn(true);
        }
        if (node.getActionBlock() != null && node.getActionBlock().isCase()) {
            for (Node child : childs) {
                if (this.isDefaultCaseBlock(child.getActionBlock())) {
                    hasIndependentBlock = true;
                }
                if (child.getType() == BlockType.HAS_ASSIGN_RETURN) continue;
                isConsideredAssingBlock = false;
            }
            if (node.getActionBlock().isRandCase()) {
                hasIndependentBlock = true;
            }
        } else {
            for (Node child : childs) {
                if (child.getActionBlock().isElse() || child.getActionBlock().isSimpleBeginEnd() || child.getActionBlock().isCase() || this.isIndependentWhileLoop(child.getActionBlock())) {
                    hasIndependentBlock = true;
                }
                if (child.getType() == BlockType.HAS_ASSIGN_RETURN) continue;
                isConsideredAssingBlock = false;
            }
        }
        if (hasIndependentBlock && allChildsHaveValidReturns && node.getType() == BlockType.IS_EMPTY) {
            if (isConsideredAssingBlock) {
                node.setType(BlockType.HAS_ASSIGN_RETURN);
            } else {
                node.setType(BlockType.HAS_NON_VOID_RETURN);
            }
            return true;
        }
        if (node.getType() == BlockType.HAS_VOID_RETURN || node.getType() == BlockType.IS_EMPTY) {
            ArrayList<Node> childsToCheck = new ArrayList();
            if (node.getType() == BlockType.HAS_VOID_RETURN) {
                Node node_aux = new Node(null, null, null, null, false);
                for (Node child : childs) {
                    RfActionBlockDef actionBlockDef = (RfActionBlockDef)child.getActionBlock().getDeclaration();
                    if (actionBlockDef == null) continue;
                    if (actionBlockDef.getStartOffset() < node.getHidOccurrence().getOffset()) {
                        node_aux.addChild(child);
                        childsToCheck.add(child);
                        continue;
                    }
                    if (actionBlockDef.getStartOffset() != node.getHidOccurrence().getOffset() || actionBlockDef.getStartVirtualOffset() >= node.getHidOccurrence().getVirtualOffset()) continue;
                    node_aux.addChild(child);
                    childsToCheck.add(child);
                }
                if (this.parentHasValidAssignBlock(childsToCheck)) {
                    node.setType(BlockType.HAS_ASSIGN_RETURN);
                    return true;
                }
                if (this.parentHasValidAssignBlock(node.getChildren())) {
                    node.setType(BlockType.HAS_ASSIGN_RETURN);
                }
                Node parent = node.getParent();
                while (parent != null) {
                    if (parent.getType() == BlockType.HAS_ASSIGN_RETURN && this.isAssignedBefore(parent, node)) {
                        return true;
                    }
                    ArrayList<Node> parentChilds = new ArrayList<Node>();
                    for (Node child : parent.getChildren()) {
                        if (!this.isAssignedBefore(child, node)) continue;
                        parentChilds.add(child);
                    }
                    if (this.parentHasValidAssignBlock(parentChilds)) {
                        return true;
                    }
                    parent = parent.getParent();
                }
                this.addHit(function.getDeclaration().getParserPath(), node.getHidOccurrence(), "No function value set before reaching return statement!");
                return false;
            }
            if (node.getType() == BlockType.IS_EMPTY) {
                childsToCheck = node.getChildren();
                if (!hasIndependentBlock) {
                    return false;
                }
                if (this.parentHasValidReturnBlock(node.getChildren())) {
                    node.setType(BlockType.HAS_NON_VOID_RETURN);
                    return true;
                }
                return false;
            }
        } else {
            if (node.getType() == BlockType.HAS_NON_VOID_RETURN) {
                if (this.parentHasValidAssignBlock(node.getChildren())) {
                    node.setType(BlockType.HAS_ASSIGN_RETURN);
                }
                return true;
            }
            if (node.getType() == BlockType.HAS_ASSIGN_RETURN) {
                return true;
            }
        }
        return false;
    }

    public boolean isAssignedBefore(Node parent, Node child) {
        HidOccurrence occ1 = parent.getHidOccurrence();
        HidOccurrence occ2 = child.getHidOccurrence();
        if (occ1 == null || occ2 == null) {
            return false;
        }
        if (occ1.getOffset() < occ2.getOffset()) {
            return true;
        }
        if (occ1.getOffset() > occ2.getOffset()) {
            return false;
        }
        return occ1.getVirtualOffset() < occ2.getVirtualOffset();
    }

    public int getNodeType(Node node, RfNamedElement function) {
        BlockType type = node.getType();
        if (type == BlockType.HAS_ASSIGN_RETURN) {
            return 1;
        }
        if (type == BlockType.HAS_NON_VOID_RETURN) {
            Node parent = node.getParent();
            while (parent != null) {
                if (this.isInfiniteLoop(parent)) {
                    node.setHasInfiteLoopWithReturn(true);
                }
                parent = parent.getParent();
            }
            return 1;
        }
        if (type == BlockType.HAS_VOID_RETURN) {
            Node parent = node.getParent();
            while (parent != null) {
                if (parent.getType() == BlockType.HAS_ASSIGN_RETURN && this.isAssignedBefore(parent, node)) {
                    node.setType(BlockType.HAS_NON_VOID_RETURN);
                    return 1;
                }
                ArrayList<Node> parentChilds = new ArrayList<Node>();
                for (Node child : parent.getChildren()) {
                    if (!this.isAssignedBefore(child, node)) continue;
                    parentChilds.add(child);
                }
                if (this.parentHasValidAssignBlock(parentChilds)) {
                    node.setType(BlockType.HAS_NON_VOID_RETURN);
                    return 1;
                }
                if (this.isInfiniteLoop(parent)) {
                    node.setHasInfiteLoopWithReturn(true);
                }
                parent = parent.getParent();
            }
            this.addHit(function.getDeclaration().getParserPath(), node.getHidOccurrence(), "No function value set before reaching return statement!");
            return 0;
        }
        if (type == BlockType.IS_EMPTY) {
            return 0;
        }
        return 0;
    }

    public boolean isInfiniteLoop(Node node) {
        RfActionBlock actionBlock = node.getActionBlock();
        if (actionBlock == null) {
            return false;
        }
        if (actionBlock.isDoWhile()) {
            return this.isNonZeroNumber(actionBlock.getExpression());
        }
        if (actionBlock.isWhile()) {
            List<IHidOperator> hidOperators = actionBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_LOOP_EXPRESSION}, true);
            if (hidOperators == null || hidOperators.isEmpty()) {
                return false;
            }
            IHidOperator loopExpr = hidOperators.get(0);
            IHidObject lhValue = loopExpr.getLHValue();
            return lhValue != null && this.isNonZeroNumber(lhValue.toString());
        }
        if (actionBlock.isForever()) {
            return true;
        }
        return actionBlock.isFor() && actionBlock.getExpression().indexOf(";;") != -1;
    }

    private boolean isNonZeroNumber(String number) {
        Number parsedNumber = DVTStringUtil.parseNumberVLOG((String)number, null, (boolean)false);
        return parsedNumber != null && parsedNumber.intValue() != 0;
    }

    public boolean parentHasValidAssignBlock(List<Node> parentChilds) {
        if (parentChilds.isEmpty()) {
            return false;
        }
        boolean foundAssignChild = false;
        boolean foundIf = false;
        boolean foundElse = false;
        int i = 0;
        while (i < parentChilds.size()) {
            if (foundElse && parentChilds.get(i).getActionBlock().isIf()) {
                foundAssignChild = true;
                break;
            }
            if (parentChilds.get(i).getActionBlock().isIf() && parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN) {
                foundIf = true;
            } else {
                if (foundIf && parentChilds.get(i).getActionBlock().isElse() && parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN) {
                    foundElse = true;
                    foundAssignChild = true;
                    break;
                }
                if (foundIf && parentChilds.get(i).getActionBlock().isElse() && parentChilds.get(i).getType() != BlockType.HAS_ASSIGN_RETURN) {
                    foundElse = false;
                } else {
                    if (parentChilds.get(i).getActionBlock().isCase() && parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN) {
                        foundAssignChild = false;
                        return true;
                    }
                    if (parentChilds.get(i).getActionBlock().isSimpleBeginEnd() && parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN) {
                        foundAssignChild = true;
                        break;
                    }
                    if (this.isIndependentWhileLoop(parentChilds.get(i).getActionBlock()) && parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN) {
                        foundAssignChild = true;
                        break;
                    }
                }
            }
            ++i;
        }
        return foundAssignChild;
    }

    public boolean parentHasValidReturnBlock(List<Node> parentChilds) {
        if (parentChilds.isEmpty()) {
            return false;
        }
        boolean foundReturnChild = false;
        boolean foundIf = false;
        boolean foundElse = false;
        int i = 0;
        while (i < parentChilds.size()) {
            if (foundElse && parentChilds.get(i).getActionBlock().isIf()) {
                foundReturnChild = true;
                break;
            }
            if (parentChilds.get(i).getActionBlock().isIf() && (parentChilds.get(i).getType() == BlockType.HAS_NON_VOID_RETURN || parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN)) {
                foundIf = true;
            } else {
                if (foundIf && parentChilds.get(i).getActionBlock().isElse() && (parentChilds.get(i).getType() == BlockType.HAS_NON_VOID_RETURN || parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN)) {
                    foundElse = true;
                    foundReturnChild = true;
                    break;
                }
                if (parentChilds.get(i).getActionBlock().isCase() && (parentChilds.get(i).getType() == BlockType.HAS_NON_VOID_RETURN || parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN)) {
                    foundReturnChild = true;
                    break;
                }
                if (parentChilds.get(i).getActionBlock().isSimpleBeginEnd() && (parentChilds.get(i).getType() == BlockType.HAS_NON_VOID_RETURN || parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN)) {
                    foundReturnChild = true;
                    break;
                }
                if (this.isIndependentWhileLoop(parentChilds.get(i).getActionBlock()) && (parentChilds.get(i).getType() == BlockType.HAS_NON_VOID_RETURN || parentChilds.get(i).getType() == BlockType.HAS_ASSIGN_RETURN)) {
                    foundReturnChild = true;
                    break;
                }
            }
            ++i;
        }
        return foundReturnChild;
    }

    public boolean isIndependentWhileLoop(RfActionBlock actionBlock) {
        if (!actionBlock.isWhile()) {
            return false;
        }
        if (actionBlock.getHidHolder() == null) {
            return false;
        }
        final boolean[] isIndependent = new boolean[1];
        actionBlock.getHidHolder().visitHidObject(null, (IHidVisitor)new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                RfHidOperator hidOp = (RfHidOperator)operator;
                IHidObject lhValue = hidOp.getLHValue();
                if (lhValue == null) {
                    return false;
                }
                if (lhValue instanceof RfHidImplicit) {
                    isIndependent[0] = true;
                }
                return false;
            }
        });
        return isIndependent[0];
    }

    public boolean isDefaultCaseBlock(RfActionBlock actionBlock) {
        List<IHidOperator> hidOperators = actionBlock.getHidOperators(CASE_ITEMS, true);
        if (hidOperators == null || hidOperators.isEmpty()) {
            return false;
        }
        IHidOperator iRfHidOperator = hidOperators.get(0);
        if (!(iRfHidOperator instanceof RfHidOperator)) {
            return false;
        }
        RfHidOperator op = (RfHidOperator)iRfHidOperator;
        ListContainer rhValues = op.getRHValues();
        if (rhValues == null || rhValues.size() != 1) {
            return false;
        }
        IHidObject caseValue = (IHidObject)rhValues.get(0);
        return caseValue instanceof RfHidImplicit && ((RfHidImplicit)caseValue).isLiteralDefault();
    }

    public boolean isSetBefore(HidOccurrence occ1, HidOccurrence occ2) {
        if (occ1 == null || occ2 == null) {
            return false;
        }
        if (occ1.getOffset() < occ2.getOffset()) {
            return true;
        }
        if (occ1.getOffset() > occ2.getOffset()) {
            return false;
        }
        return occ1.getVirtualOffset() < occ2.getVirtualOffset();
    }

    private String printPath(Node node, Node root, int numberOfTabs) {
        StringBuilder path = new StringBuilder("");
        List<Node> children = node.getChildren();
        boolean foundIf = false;
        if (node.getActionBlock() != null) {
            ReparseInfo.ReparseElement[] reparseStack;
            path.append(node.getActionBlock().getLine());
            path.append(":");
            int aux = numberOfTabs;
            while (aux > 0) {
                path.append("  ");
                --aux;
            }
            String info = null;
            RfActionBlockDef actionBlock = (RfActionBlockDef)node.getActionBlock().getDeclaration();
            if (actionBlock.getReparseInfo() != null && (reparseStack = actionBlock.getReparseInfo().getReparseStack()) != null && actionBlock.getReparseInfo().getReparseStackSize() > 0) {
                info = "`";
                info = String.valueOf(info) + reparseStack[0].getReparseMacroName();
            }
            if (info == null) {
                if (node.getActionBlock().isIf()) {
                    info = "if";
                    info = String.valueOf(info) + " (" + node.getActionBlock().getExpression() + ")";
                } else if (node.getActionBlock().isElse()) {
                    info = "else";
                } else if (node.getActionBlock().isSimpleBeginEnd()) {
                    info = "begin";
                } else if (node.getActionBlock().isCase()) {
                    info = "case";
                    info = String.valueOf(info) + " (" + node.getActionBlock().getExpression() + ")";
                } else {
                    info = node.getActionBlock().isCaseItem() ? String.valueOf(node.getActionBlock().getExpression()) + ":" : (this.isIndependentWhileLoop(node.getActionBlock()) ? "while (1)" : "");
                }
            }
            if (node.getActionBlock().getDeclaration().getParserPath() != null) {
                path.append(String.valueOf(this.link(info, node.getActionBlock().getDeclaration().getParserPath().path, node.getActionBlock().getLine())) + '\n');
            }
        }
        if (children == null || children.isEmpty()) {
            return path.toString();
        }
        boolean found = false;
        for (Node child : children) {
            RfActionBlock actionBlock = child.getActionBlock();
            BlockType type = child.getType();
            if (node.equals(root) && path.toString().contains("return")) {
                return path.substring(0, path.length() - 6);
            }
            if (actionBlock.isIf() && type == BlockType.IS_EMPTY) {
                foundIf = true;
                path.append(this.printPath(child, root, numberOfTabs + 1));
                found = true;
            } else {
                if (actionBlock.isIf() && type == BlockType.HAS_VOID_RETURN) {
                    foundIf = true;
                    path.append(this.printPath(child, root, numberOfTabs + 1));
                    path.append("return");
                    return path.toString();
                }
                if (actionBlock.isIf() && (type == BlockType.HAS_ASSIGN_RETURN || type == BlockType.HAS_NON_VOID_RETURN)) {
                    foundIf = false;
                }
            }
            if (actionBlock.isElse() && !foundIf && type == BlockType.IS_EMPTY) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                found = true;
            } else if (actionBlock.isElse() && !foundIf && type == BlockType.HAS_VOID_RETURN) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                path.append("return");
                return path.toString();
            }
            if (actionBlock.isCase() && type == BlockType.IS_EMPTY) {
                aux = this.printPath(child, root, numberOfTabs + 1);
                if (aux.contains(":")) {
                    path.append(aux);
                }
                found = true;
            } else if (actionBlock.isCase() && type == BlockType.HAS_VOID_RETURN) {
                aux = this.printPath(child, root, numberOfTabs + 1);
                if (aux.contains(":")) {
                    path.append(aux);
                }
                path.append("return");
                return path.toString();
            }
            if (actionBlock.isCaseItem() && type == BlockType.IS_EMPTY) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                found = true;
            } else if (actionBlock.isCaseItem() && type == BlockType.HAS_VOID_RETURN) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                path.append("return");
                return path.toString();
            }
            if (actionBlock.isSimpleBeginEnd() && type == BlockType.IS_EMPTY) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                found = true;
            } else if (actionBlock.isSimpleBeginEnd() && type == BlockType.HAS_VOID_RETURN) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                path.append("return");
                return path.toString();
            }
            if (this.isIndependentWhileLoop(actionBlock) && type == BlockType.IS_EMPTY) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                found = true;
            } else if (this.isIndependentWhileLoop(actionBlock) && type == BlockType.HAS_VOID_RETURN) {
                path.append(this.printPath(child, root, numberOfTabs + 1));
                path.append("return");
                return path.toString();
            }
            if (node.equals(root) || !found) continue;
            return path.toString();
        }
        return path.toString();
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static enum BlockType {
        HAS_VOID_RETURN,
        HAS_NON_VOID_RETURN,
        HAS_ASSIGN_RETURN,
        IS_EMPTY;

    }

    private static class Node {
        private Node parent;
        private List<Node> childs;
        private RfActionBlock actionBlock;
        private BlockType type;
        private HidOccurrence hidOccurrence;
        private boolean hasInfinteLoopWithReturn;

        public Node(Node parent, RfActionBlock actionBlock, HidOccurrence hidOccurrence, BlockType type, boolean hasInfiniteLoopWithReturn) {
            this.parent = parent;
            this.childs = new ArrayList<Node>();
            this.actionBlock = actionBlock;
            this.hidOccurrence = hidOccurrence;
            this.type = type;
            this.hasInfinteLoopWithReturn = hasInfiniteLoopWithReturn;
        }

        public Node getParent() {
            return this.parent;
        }

        public List<Node> getChildren() {
            return this.childs;
        }

        public void addChild(Node child) {
            this.childs.add(child);
        }

        public RfActionBlock getActionBlock() {
            return this.actionBlock;
        }

        public HidOccurrence getHidOccurrence() {
            return this.hidOccurrence;
        }

        public void setHidOccurrence(HidOccurrence hidOccurrence) {
            this.hidOccurrence = hidOccurrence;
        }

        public BlockType getType() {
            return this.type;
        }

        public void setType(BlockType type) {
            this.type = type;
        }

        public void setHasInfiteLoopWithReturn(boolean hasInfiniteLoopWithReturn) {
            this.hasInfinteLoopWithReturn = hasInfiniteLoopWithReturn;
        }

        public boolean getHasInfiniteLoopWithReturn() {
            return this.hasInfinteLoopWithReturn;
        }
    }
}

