/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.30")
@CheckID(value="SVTB.12.2.9")
@CheckName(value="SVTB.12.2.9")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN})
@CheckTitle(value="Functions not returning any values must be declared void")
@CheckDescription(value="If the function doesn't have any return statements and the implicit result value is not set, then the return type must be void.\n\nExamples:\n\nfunction void f1(); // allowed\nendfunction\n\nfunction int f2(); // not allowed\n\tint x = 1;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_2_9
extends OVMComplianceCheck {
    private static Set<String> listMethods = new HashSet<String>();
    private static Set<String> queueMethods = new HashSet<String>();

    static {
        listMethods.add("reverse");
        listMethods.add("sort");
        listMethods.add("rsort");
        listMethods.add("shuffle");
        queueMethods.add("insert");
        queueMethods.add("delete");
        queueMethods.add("pop_front");
        queueMethods.add("pop_back");
        queueMethods.add("push_front");
        queueMethods.add("push_back");
    }

    public Check_SVTB_12_2_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            RfHidHolder hidHolder;
            RfDefElement declaration;
            if (!(function instanceof RfFunction) || ((RfFunction)function).isConstructor() || ((RfFunction)function).isVirtual() || ((RfFunction)function).isVoid() || ((RfFunction)function).isLet() || (declaration = function.getDeclaration()) != null && ((RfFunctionDef)declaration).isPrototype()) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(function.getFile()) || (hidHolder = function.getHidHolder()) != null && this.visitFunctionBlock(hidHolder, function)) continue;
            List<RfActionBlock> actionBlocks = function.getLocalMembers(RfActionBlock.class);
            if (actionBlocks == null || actionBlocks.isEmpty()) {
                this.addHit(function, "Function '" + LintUtils.getNamedElementFullName(function) + "' does not return any value!");
                continue;
            }
            boolean foundReturn = false;
            for (RfActionBlock actionBlock : actionBlocks) {
                if (!this.checkActionBlock(actionBlock, function)) continue;
                foundReturn = true;
                break;
            }
            if (foundReturn) continue;
            this.addHit(function, "Function '" + LintUtils.getNamedElementFullName(function) + "' does not return any value!");
        }
    }

    private boolean checkActionBlock(RfActionBlock actionBlock, RfNamedElement function) {
        if (this.visitFunctionBlock(actionBlock.getHidHolder(), function)) {
            return true;
        }
        List<RfActionBlock> actionBlocks = actionBlock.getLocalMembers(RfActionBlock.class);
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return false;
        }
        for (RfActionBlock block : actionBlocks) {
            if (!this.checkActionBlock(block, function)) continue;
            return true;
        }
        return false;
    }

    public boolean visitFunctionBlock(RfHidHolder hidHolder, final RfNamedElement function) {
        if (hidHolder == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidObject>(){
            private static volatile /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind;

            /*
             * Unable to fully structure code
             */
            public boolean visit(IHidObject hidObject) {
                switch (1.$SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind()[hidObject.getHidKind().ordinal()]) {
                    case 4: {
                        hidOp = (RfHidOperator)hidObject;
                        if (hidOp.isReturnStatement()) {
                            result[0] = true;
                            return false;
                        }
                        if (!hidOp.isAssignment() && !hidOp.isArithmeticAssignment() && !hidOp.isLogicalAssignment() && !hidOp.isIncrementOrDecrement()) ** GOTO lbl31
                        lhValue = hidOp.getLHValue();
                        if (!(lhValue instanceof RfHidAccess)) ** GOTO lbl19
                        parentHid = ((RfHidAccess)lhValue).getParentHid();
                        if (parentHid != null) ** GOTO lbl14
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            parentHid = parentHid.getParentHid();
lbl14:
                            // 2 sources

                            ** while (parentHid.getParentHid() != null)
                        }
lbl15:
                        // 1 sources

                        if (!parentHid.getName().equals(function.getName())) {
                            return true;
                        }
                        result[0] = true;
                        return false;
lbl19:
                        // 1 sources

                        if (!(lhValue instanceof RfHid)) {
                            return true;
                        }
                        parentHid = (RfHid)lhValue;
                        while (parentHid.getParentHid() != null) {
                            parentHid = parentHid.getParentHid();
                        }
                        if (!parentHid.getName().equals(function.getName())) {
                            return true;
                        }
                        if (!(parentHid.getElement() instanceof RfResultImplicitVariable)) {
                            return true;
                        }
                        result[0] = true;
                        return false;
lbl31:
                        // 1 sources

                        return true;
                    }
                    case 1: {
                        hid = (RfHid)hidObject;
                        if (!hid.isMethodCall(false)) {
                            return true;
                        }
                        if (hid.getParentHid() != null) {
                            predefinedFunction = null;
                            if (hid.getElement() instanceof RfPredefinedFunction) {
                                predefinedFunction = (RfPredefinedFunction)hid.getElement();
                            }
                            parentHid = hid.getParentHid();
                            element = parentHid.getElement();
                            do {
                                if (!((element = parentHid.getElement()) instanceof RfResultImplicitVariable)) continue;
                                if (predefinedFunction == null) {
                                    result[0] = true;
                                    return false;
                                }
                                enclosingScope = predefinedFunction.getEnclosingScope();
                                if (!(enclosingScope instanceof RfListType) || !this.isChangingStructure((RfListType)enclosingScope, predefinedFunction)) continue;
                                result[0] = true;
                                return false;
                            } while ((parentHid = parentHid.getParentHid()) != null);
                        }
                        if ((methodCalls = MethodCallUtils.getMethodCalls((IHid)hid)).isEmpty()) {
                            return true;
                        }
                        for (MethodCall methodCall : methodCalls) {
                            if (methodCall.argumentValuesMap == null) continue;
                            for (Map.Entry<K, V> argumentValue : methodCall.argumentValuesMap.entrySet()) {
                                if (!(argumentValue.getKey() instanceof RfField)) continue;
                                argument = (RfField)argumentValue.getKey();
                                values = (Set)argumentValue.getValue();
                                if (values == null || values.isEmpty() || (element = (auxHid = (IHid)values.iterator().next()).getElement()) == null || argument.isInput() || argument.isConstRef() || !argument.isOutput() && !argument.isInout() && !argument.isRef() || !element.getName().equals(function.getName())) continue;
                                result[0] = true;
                                return false;
                            }
                        }
                        return true;
                    }
                }
                return true;
            }

            private boolean isChangingStructure(RfListType enclosingScope, RfPredefinedFunction predefinedFunction) {
                String name = predefinedFunction.getName();
                if (listMethods.contains(name)) {
                    return true;
                }
                if (enclosingScope.isQueue()) {
                    return queueMethods.contains(name);
                }
                if (enclosingScope.isAssociativeArray()) {
                    return name.equals("delete");
                }
                if (enclosingScope.isDynamicArray()) {
                    return name.equals("new") || name.equals("delete");
                }
                return false;
            }

            public void setHolder(IHidHolder holder) {
            }

            public void setParserPath(ParserPath parserPath) {
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }

            static /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind() {
                if ($SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind != null) {
                    return $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind;
                }
                int[] nArray = new int[IHidObject.HidKind.values().length];
                try {
                    nArray[IHidObject.HidKind.ACCESS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.HID.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.HOLDER.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.IMPLICIT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[IHidObject.HidKind.OPERATOR.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind = nArray;
                return nArray;
            }
        });
        return result[0];
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

