/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractTypeAndDirectionCheck;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.12.3.7")
@CheckName(value="SVTB.12.3.7")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="Specify type and direction of all arguments")
@CheckDescription(value="In SystemVerilog, method types are sticky - and hold until the next type / direction change. Additionally, method arguments have a default type.\nThis applies to any construct with a formal argument list. Because this is confusing and leads to some common mistakes it is not allowed.\nTo be on the safe side, tasks/functions with at least one non-input argument, must declare the direction for every argument.\n\nExamples:\ntask foo(a, b, output bit [15:0] u, v, ref byte c[]); // not allowed\ntask foo(input logic a, input logic b, output bit [15:0] u, output bit [15:0]v, ref byte c[]); // allowed\ntask foo(logic a, logic b, output bit [15:0] u, inout bit [15:0] v, ref byte c[]); // allowed IFF skipInputsDeclaredFirst\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_3_7
extends AbstractTypeAndDirectionCheck {
    @CheckParameter(defaultValue="true", description="When true, it checks the argument data type.", name="checkArgumentDataType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckArgumentDataType;
    @CheckParameter(defaultValue="true", description="When true, it checks the argument direction.", name="checkArgumentDirection", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckArgumentDirection;
    @CheckParameter(defaultValue="false", description="When true, it is possible to have implicit defined inputs first, followed by any explicit non-input direction.", name="skipInputsDeclaredFirst", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipInputsDeclaredFirstValue;

    public Check_SVTB_12_3_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.implicitType = 1;
    }

    @Override
    protected List<RfDefElement> getAllElementsToCheck() {
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        NullProtectedList<RfNamedElement> allFunctions = this.fOVMProject.getAllFunctions();
        for (RfNamedElement function : allFunctions) {
            Collection functionDefs = function.getDeclarations();
            if (functionDefs == null || functionDefs.isEmpty()) continue;
            result.addAll(functionDefs);
        }
        NullProtectedList<RfNamedElement> allTasks = this.fOVMProject.getAllTasks();
        for (RfNamedElement task : allTasks) {
            Collection taskDefs = task.getDeclarations();
            if (taskDefs == null || taskDefs.isEmpty()) continue;
            result.addAll(taskDefs);
        }
        NullProtectedList<RfNamedElement> allCovergroups = this.fOVMProject.getAllCovergroups();
        for (RfNamedElement covergroup : allCovergroups) {
            Collection covergroupDefs = covergroup.getDeclarations();
            if (covergroupDefs == null || covergroupDefs.isEmpty()) continue;
            result.addAll(covergroupDefs);
        }
        return result;
    }

    @Override
    protected List<RfField> getCheckedMembers(Object element) {
        if (!(element instanceof RfDefElement)) {
            return null;
        }
        ArrayList<RfField> result = new ArrayList<RfField>();
        List<RfField> args = ((RfDefElement)element).getArgumentsWithPrefix("", 2);
        if (args != null && !args.isEmpty()) {
            result.addAll(args);
        }
        return result;
    }

    @Override
    protected String getMemberInfo(Object member) {
        if (!(member instanceof RfField)) {
            return null;
        }
        return "Argument '" + ((RfField)member).getName() + "'";
    }

    @Override
    protected boolean shouldSkip() {
        return this.pSkipInputsDeclaredFirstValue;
    }

    @Override
    protected boolean checkMemberDataType() {
        return this.pCheckArgumentDataType;
    }

    @Override
    protected boolean checkMemberDirection() {
        return this.pCheckArgumentDirection;
    }
}

