/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="20.1.5")
@CheckID(value="SVTB.12.3.8")
@CheckName(value="SVTB.12.3.8")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="Do not use inout or output scalar arguments")
@CheckDescription(value="Do not use inout or output scalar arguments. Utilize return type for scalar value, instead of inout, or output argument.\n\nExamples:\n\nfunction int foo(input int a); // allowed\n\treturn a + 10;\nendfunction\n\nfunction bar(input int a, inout int b, output int c); // not allowed\n\tb = a + 5;\n\tc = a + 10;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_3_8
extends OVMComplianceCheck {
    private static final String REF = "ref";
    private static final String INPUT = "input";
    @CheckParameter(defaultValue="false", description="When true, ref scalar arguments will be skipped.", name="skipScalarRefArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipScalarRefArguments;
    @CheckParameter(defaultValue="false", description="When true, arguments of tasks are skipped.", name="skipTasks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipTasks;

    public Check_SVTB_12_3_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IRfNamedElementVisitor neVisitor = namedElement -> {
            if (namedElement.isPredefined()) {
                return true;
            }
            if (!(namedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)namedElement;
            if (this.pSkipTasks && function.isTask()) {
                return true;
            }
            if (this.isPrewaived(function)) {
                return true;
            }
            this.notifyCheckAlive();
            List<RfField> arguments = function.getArgumentsWithPrefix("", 2);
            if (arguments == null) {
                return true;
            }
            for (RfField argument : arguments) {
                IRfNamedElement argumentType = argument.getAssociatedType();
                String unpackedDimension = "";
                if (argumentType instanceof RfTypeAlias) {
                    argumentType = ((RfTypeAlias)argumentType).getTranslatedType();
                }
                if (argumentType instanceof RfListType) {
                    unpackedDimension = ((RfListType)argumentType).getUnpackedDimension();
                }
                boolean isArray = unpackedDimension != null && !unpackedDimension.isEmpty();
                String direction = argument.getDirectionString();
                if (this.pSkipScalarRefArguments && direction.contains(REF) || direction.equals(INPUT) || isArray) continue;
                this.addHit(argument, "Scalar argument '" + argument.getName() + "' of " + function.getFullName() + "() is " + direction + "!");
            }
            return true;
        };
        rfProject.accept(neVisitor);
    }

    private boolean isPrewaived(RfFunction function) {
        RfFileDef functionFile = function.getFile();
        if (functionFile == null) {
            return true;
        }
        ParserPath parserPath = functionFile.getParserPath();
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

