/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_12_4;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.12.4")
@CheckName(value="SVTB.12.4")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.PARENTHESIS})
@CheckTitle(value="All method calls should have parentheses")
@CheckDescription(value="Although SystemVerilog permits the parentheses to be missing in method calls without arguments, all method calls should have parentheses.\nEven if empty, the argument list must be provided. This improves readability. A method call always has the () paren, a member or any other variable has no parens.\n\nExamples:\nmyvar = myclass.mymethod(); // method call\nmyvar = myclass.m_mymember; // member copy\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_12_4.class)
public class Check_SVTB_12_4
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="true", description="Checks constructor calls - new() - if true.", name="checkConstructorCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckConstructorCallsValue;
    @CheckParameter(defaultValue="$time, $stime, $realtime", description="Comma separated list of allowed calls without parentheses.", name="allowedCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedCallsValue;

    public Check_SVTB_12_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            private ParserPath parserPath;
            private IHidHolder holder;

            public boolean visit(IHidObject hidObject) {
                if (!(hidObject instanceof RfHid)) {
                    return true;
                }
                if (((RfHid)hidObject).hasQualifier(HidQualifierCache.DISABLE_QUALIFIER)) {
                    return true;
                }
                Check_SVTB_12_4.this.notifyCheckAlive();
                if (Check_SVTB_12_4.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!(this.holder instanceof RfHidHolder)) {
                    return true;
                }
                RfHid hid = (RfHid)hidObject;
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (((RfFunction)element).isLet() || ((RfFunction)element).isDynamicArray() || ((RfFunction)element).isProduction()) {
                    return true;
                }
                if (!Check_SVTB_12_4.this.pCheckConstructorCallsValue && ((RfFunction)element).isConstructor()) {
                    return true;
                }
                if ("triggered".equals(element.getName()) && hid.getParentHid() != null && hid.getParentHid().getElement() instanceof RfField && ((RfField)hid.getParentHid().getElement()).isEvent()) {
                    return true;
                }
                if (Check_SVTB_12_4.this.pAllowedCallsValue.contains(element.getName())) {
                    return true;
                }
                LinkedHashSet<HidOccurrence> allOccurences = new LinkedHashSet<HidOccurrence>(Collections.singletonList(hid.getOccurrence()));
                if (hid.hasAccesses()) {
                    ListContainer accesses = hid.getAccesses();
                    for (HidAccess access : accesses) {
                        if (!(access instanceof RfHidAccessArgs)) continue;
                        List<? extends IHidObject> argumentValues = ((RfHidAccessArgs)access).getArgumentValues();
                        if (!((RfHidAccessArgs)access).hasEmptyParentheses() && argumentValues.isEmpty()) continue;
                        allOccurences.remove(((RfHidAccessArgs)access).getOccurrence());
                    }
                }
                for (HidOccurrence occurrence : allOccurences) {
                    int hitOffsetOnLine = Check_SVTB_12_4.this.getOffsetOnLine(this.parserPath, occurrence);
                    if (occurrence.getReparseInfo() instanceof ReparseInfo) {
                        ReparseInfo.ReparseElement reparseElement;
                        ReparseInfo info = (ReparseInfo)occurrence.getReparseInfo();
                        ReparseInfo.ReparseElement[] stack = info.getReparseStack();
                        if (stack == null || stack.length <= 0 || (reparseElement = stack[0]) == null || reparseElement.getReparseMacroParams() == null) continue;
                        String[] stringArray = reparseElement.getReparseMacroParams();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String macroParam = stringArray[n2];
                            if (macroParam.equals(element.getName())) {
                                Check_SVTB_12_4.this.addHit(this.parserPath, occurrence.getLine(), "Call '" + LintUtils.getHidName((IHid)hid) + "' at line offset " + hitOffsetOnLine + " does not have parentheses!", null, new VerissimoAutofixAdditionalInfo((Object)hid));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    Check_SVTB_12_4.this.addHit(this.parserPath, occurrence.getLine(), "Call '" + LintUtils.getHidName((IHid)hid) + "' at line offset " + hitOffsetOnLine + " does not have parentheses!", null, new VerissimoAutofixAdditionalInfo((Object)hid));
                }
                return true;
            }

            public void setHolder(IHidHolder holder) {
                this.holder = holder;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private int getOffsetOnLine(ParserPath parserPath, HidOccurrence occurrence) {
        int offsetOnLine = 0;
        LiteralToken occurrenceToken = this.getWSParser().getTokenContainingOffset(occurrence.getOffset(), parserPath);
        if (occurrenceToken != null) {
            offsetOnLine = occurrenceToken.getOffsetLine() + occurrence.getOffset() - occurrenceToken.getOffsetFile();
        }
        return offsetOnLine;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

