/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1.4")
@CheckID(value="SVTB.12.5")
@CheckName(value="SVTB.12.5")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.BIND})
@CheckTitle(value="Bind arguments by name when calling methods with many arguments")
@CheckDescription(value="SystemVerilog allows arguments to tasks and functions to be bound by name. This improves readability, especially when working with many arguments.\n\nExample:\n send_command(._transaction(trans),\n              ._delay_ps(my_delay),\n              ._override(1'b0),\n              ._interleave(1'b1),\n              ._send_with_errors(1'b0));\nIs much more readable than:\n send_command(trans, my_delay, 0, 1, 0);\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_5
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="3", description="Check only method calls with more than nof arguments.", name="checkIffNofArgumentsGreaterThen", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER, isVisible=false)
    Integer pCheckIffNofArgumentsGreaterThenValue;
    @CheckParameter(defaultValue="3", description="Check only method calls with more than nof arguments.", name="checkIffNofArgumentsGreaterThan", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    Integer pCheckIffNofArgumentsGreaterThanValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipCallsInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pSkipCallsInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="$sformatf, $swrite", description="Comma separated list of allowed method full names without argument binding (pkg_name::class_name.method_name).", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pskipMethodsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of patterns for methods full name that are allowed to be called without argument binding.", name="skipMethodsPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    HashSet<Pattern> pSkipMethodsPatterns;
    @Deprecated
    private static final String pAllowedCalls = "allowedCalls";

    public Check_SVTB_12_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public HashSet<String> getCommaSeparatedPropertyAsHashSet(String aKey) {
        String propertyValue = this.getProperty(aKey);
        HashSet<String> result = new HashSet<String>();
        if (propertyValue != null && !propertyValue.isEmpty()) {
            String[] splitPropertyValue = propertyValue.split(",");
            int i = 0;
            while (i < splitPropertyValue.length) {
                if (splitPropertyValue[i] != null) {
                    result.add(splitPropertyValue[i].trim());
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public void performCheckImpl() {
        Map<String, CheckParameter> allParameters = this.getAllParameters();
        HashSet<String> pAllowedCallsValue = this.getCommaSeparatedPropertyAsHashSet(pAllowedCalls);
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor(this, allParameters, pAllowedCallsValue));
    }

    private boolean hasAllowedPattern(String functionName) {
        for (Pattern pattern : this.pSkipMethodsPatterns) {
            if (!pattern.matcher(functionName).matches()) continue;
            return true;
        }
        return false;
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private OVMComplianceCheck check;
        private Map<String, CheckParameter> allParameters;
        private HashSet<String> pAllowedCallsValue;

        public LocalHidVisitor(OVMComplianceCheck check, Map<String, CheckParameter> allParameters, HashSet<String> pAllowedCallsValue) {
            this.check = check;
            this.allParameters = allParameters;
            this.pAllowedCallsValue = pAllowedCallsValue;
        }

        public boolean visit(RfHid hidObject) {
            if (Check_SVTB_12_5.this.fOVMProject.getProjectWaivers().pathIsPrewaived(this.parserPath, this.check)) {
                return true;
            }
            Check_SVTB_12_5.this.notifyCheckAlive();
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)hidObject.getElement();
            List<IRfFieldElement> arguments = function.getArguments();
            if (arguments == null || arguments.isEmpty()) {
                return true;
            }
            if (arguments.size() == 1 && arguments.get(0) instanceof RfPredefinedField && "dummy_arg".equals(((IRfNamedElement)arguments.get(0)).getName())) {
                return true;
            }
            if (LintUtils.isInsideMacroWithPrefix(hidObject.getOccurrence(), Check_SVTB_12_5.this.pSkipCallsInsideMacrosWithPrefixesValue)) {
                return true;
            }
            if (this.pAllowedCallsValue.contains(function.getName())) {
                return true;
            }
            String functionName = LintUtils.getNamedElementFullName(function);
            if (Check_SVTB_12_5.this.pskipMethodsValue.contains(functionName)) {
                return true;
            }
            if (Check_SVTB_12_5.this.hasAllowedPattern(functionName)) {
                return true;
            }
            if (!(hidObject.getFirstAccess() instanceof RfHidAccessArgs)) {
                return true;
            }
            List<? extends IHidObject> argumentValues = ((RfHidAccessArgs)hidObject.getFirstAccess()).getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty()) {
                return true;
            }
            if (this.allParameters.containsKey("checkIffNofArgumentsGreaterThen") && Check_SVTB_12_5.this.pCheckIffNofArgumentsGreaterThenValue != 3 ? argumentValues.size() <= Check_SVTB_12_5.this.pCheckIffNofArgumentsGreaterThenValue : argumentValues.size() <= Check_SVTB_12_5.this.pCheckIffNofArgumentsGreaterThanValue) {
                return true;
            }
            for (IHidObject iHidObject : argumentValues) {
                if (MethodCallUtils.isNamedConnected((IHidObject)iHidObject)) continue;
                Check_SVTB_12_5.this.addHit(this.parserPath, hidObject, "Arguments of '" + hidObject.getName() + "' are not bound by name!");
                break;
            }
            return true;
        }
    }
}

