/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="15.1.9")
@CheckID(value="SVTB.12.6")
@CheckName(value="SVTB.12.6")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.STYLING, RuleLabel.CODE_COMPLEXITY})
@CheckTitle(value="Maximum method line count")
@CheckDescription(value="A single method should have no more than 'maxNofLines'. A method body with more than this many lines becomes difficult to read.\nMethods with high line counts should be broken into multiple sub-methods.\n\nExamples for maxNofLines=3:\n\nfunction int foo(int a); // allowed\n\treturn a + 10;\nendfunction\n\nfunction int bar(int a); // not allowed\n\tint b;\n\tint c;\n\tb = a + 10;\n\tc = b << 2;\n\treturn c;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_6
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="150", description="Maximum method line count.", name="maxNofLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private Integer maxNofLines;
    @CheckParameter(defaultValue="", description="Comma separated list of patterns for lines that will be skipped.", name="skipLinePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pSkipLinePatterns;
    private LinesCache linesCache = new LinesCache(this);

    public Check_SVTB_12_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                Check_SVTB_12_6.this.notifyCheckAlive();
                if (namedElement instanceof RfFunction) {
                    if (Check_SVTB_12_6.this.checkPreWaivers(namedElement)) {
                        return true;
                    }
                    RfFunction functionElement = (RfFunction)namedElement;
                    if (!functionElement.isPredefined()) {
                        Check_SVTB_12_6.this.analyzeFunction(functionElement);
                    }
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private void analyzeFunction(RfFunction functionElement) {
        RfFileDef defFile;
        this.notifyCheckAlive();
        if (functionElement == null) {
            return;
        }
        RfDefElement defElement = functionElement.getImplementation();
        if (defElement == null) {
            return;
        }
        ParserPath path = defElement.getParserPath();
        int startLine = defElement.getStartLine();
        int endLine = defElement.getEndLine();
        int nofLines = endLine - startLine - 1;
        if (!this.pSkipLinePatterns.isEmpty()) {
            int i = startLine;
            while (i < endLine - 1) {
                String currentLine = this.linesCache.getLine(path, i);
                if (currentLine != null) {
                    for (Pattern pattern : this.pSkipLinePatterns) {
                        if (!pattern.matcher(currentLine).matches()) continue;
                        --nofLines;
                        break;
                    }
                }
                ++i;
            }
            this.linesCache.clear();
        }
        if (nofLines > this.maxNofLines && (defFile = defElement.getDefFile()) != null) {
            this.addHit(defFile.getParserPath(), defElement.getStartLine(), String.valueOf(functionElement.getFullName()) + "() is too long: " + nofLines + " lines!", defElement.getReparseInfo());
        }
    }

    public boolean checkPreWaivers(RfNamedElement namedElem) {
        if (namedElem.getFile() == null) {
            return true;
        }
        ParserPath parserPath = namedElem.getFile().getParserPath();
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LinesCache {
        private Map<ParserPath, List<String>> readFiles = new HashMap<ParserPath, List<String>>();
        private OVMComplianceCheck check;

        public LinesCache(OVMComplianceCheck check) {
            this.check = check;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readFile(ParserPath parserPath) {
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(parserPath.path));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        this.readFiles.putIfAbsent(parserPath, new ArrayList());
                        this.readFiles.get(parserPath).add(line);
                    }
                    return;
                }
                catch (FileNotFoundException e) {
                    Check_SVTB_12_6.this.fOVMProject.notifyCheckException(this.check, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e2) {
                        Check_SVTB_12_6.this.fOVMProject.notifyCheckException(this.check, e2);
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                    return;
                }
                catch (IOException e) {
                    Check_SVTB_12_6.this.fOVMProject.notifyCheckException(this.check, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e3) {
                        Check_SVTB_12_6.this.fOVMProject.notifyCheckException(this.check, e3);
                        DVTLogger.INSTANCE.logError((Throwable)e3);
                    }
                    return;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Check_SVTB_12_6.this.fOVMProject.notifyCheckException(this.check, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }

        private void clear() {
            this.readFiles.clear();
        }

        public String getLine(ParserPath parserPath, int line) {
            if (!this.readFiles.containsKey(parserPath)) {
                this.readFile(parserPath);
            }
            List<String> linesFile = this.readFiles.get(parserPath);
            if (line < 0 || line > linesFile.size()) {
                return null;
            }
            return linesFile.get(line);
        }
    }
}

