/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="15.1.9")
@CheckID(value="SVTB.12.7")
@CheckName(value="SVTB.12.7")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN})
@CheckTitle(value="Do not use the implicit syntax for function return type")
@CheckDescription(value="Explicitly specify the function return type or void. Event if the standard allows using an implicit syntax, very few are aware about the logic implicit type.\n\nExamples:\n   function f1(); // not allowed\n   function [1:0] f2(); // not allowed\n   function unsigned f3(); // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_7
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, allows the functions that do not possess a return statement, to use an implicit return type syntax.", name="allowIfNoReturn", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowIfNoReturnValue;

    public Check_SVTB_12_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                Check_SVTB_12_7.this.notifyCheckAlive();
                if (Check_SVTB_12_7.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                if (!(namedElement instanceof RfFunction)) {
                    return true;
                }
                final RfFunction functionElement = (RfFunction)namedElement;
                if (!functionElement.isFunction()) {
                    return true;
                }
                DataType returnDataType = functionElement.getDataType();
                if (returnDataType == null) {
                    return true;
                }
                String returnTypeString = returnDataType.getType();
                if (returnTypeString != null && !returnTypeString.isEmpty()) {
                    return true;
                }
                if (functionElement.getEnclosingScope() instanceof RfCovergroup) {
                    return true;
                }
                if (!Check_SVTB_12_7.this.pAllowIfNoReturnValue) {
                    Check_SVTB_12_7.this.addHitOnFunction(functionElement);
                    return true;
                }
                if (functionElement.getHidHolder() == null) {
                    return true;
                }
                final boolean[] hasReturn = new boolean[1];
                functionElement.visitHidObject(null, new IHidVisitor<IHidOperator>(){

                    public boolean visit(IHidOperator hidOperator) {
                        RfHidOperator rfOperator = (RfHidOperator)hidOperator;
                        if (rfOperator.isReturnStatement()) {
                            hasReturn[0] = true;
                        }
                        if (!rfOperator.isAssignment()) {
                            return true;
                        }
                        IHidObject lhValue = rfOperator.getLHValue();
                        if (lhValue.equals(functionElement)) {
                            hasReturn[0] = true;
                        }
                        return true;
                    }

                    public void setHolder(IHidHolder holder) {
                        super.setHolder(holder);
                    }

                    public Class<IHidOperator> getType() {
                        return IHidOperator.class;
                    }
                });
                if (!hasReturn[0]) {
                    return true;
                }
                Check_SVTB_12_7.this.addHitOnFunction(functionElement);
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private void addHitOnFunction(RfFunction rfFunction) {
        if (rfFunction.isExtern() && rfFunction.getImplementation() != null) {
            RfDefElement implementation = rfFunction.getImplementation();
            this.addHit(implementation.getParserPath(), implementation.getStartLine(), "Function '" + LintUtils.getNamedElementFullName(rfFunction) + "()' has no explicit return type!", null);
        } else {
            this.addHit(rfFunction, "Function '" + LintUtils.getNamedElementFullName(rfFunction) + "()' has no explicit return type!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

