/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="16.1.17")
@CheckID(value="SVTB.12.8")
@CheckName(value="SVTB.12.8")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.CODE_COMPLEXITY})
@CheckTitle(value="Maximum method call stack size")
@CheckDescription(value="Method call stack size must not exceed <maxStackSize>.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_SVTB_12_8
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="4", description="Maximum call stack size.", name="maxStackSize", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private Integer pMaxStackSizeValue;
    @CheckParameter(defaultValue="false", description="Ignore calls inside fork.", name="ignoreForks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreForksValue;
    @CheckParameter(defaultValue="uvm", description="Comma separated list of macro prefixes. The methods declared inside specified macros are not checked.", name="ignoreCallsToMethodsDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pIgnoreCallsToMethodsDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="uvm", description="Comma separated list of package prefixes. The methods declared inside specified packages are not checked.", name="ignoreCallsToMethodsDeclaredInsidePackagesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCallsToMethodsDeclaredInsidePackagesWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of method full names. Ignore calls to specified methods.", name="ignoreCallsTo", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pIgnoreCallsToValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes. Don't check calls inside specified macros.", name="ignoreCallsInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pIgnoreCallsInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="true", description="When true, ignore calls to predefined methods.", name="ignoreCallsToPredefinedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreCallsToPredefinedMethodsValue;

    public Check_SVTB_12_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        ArrayList<RfNamedElement> methods = new ArrayList<RfNamedElement>();
        methods.addAll(this.fOVMProject.getAllFunctions());
        methods.addAll(this.fOVMProject.getAllTasks());
        HashMap<RfNamedElement, List<FunctionCallInfo>> map = new HashMap<RfNamedElement, List<FunctionCallInfo>>();
        for (RfNamedElement rfNamedElement : methods) {
            RfFileDef fileDef = rfNamedElement.getFile();
            if (fileDef != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this)) continue;
            this.visitMethods(rfNamedElement, map, this.pIgnoreForksValue);
        }
        for (Map.Entry entry : map.entrySet()) {
            RfNamedElement method = (RfNamedElement)entry.getKey();
            List methodStack = (List)entry.getValue();
            if (methodStack.size() + 1 <= this.pMaxStackSizeValue) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Method '").append(method.getFullName()).append("' has call stack size ").append(methodStack.size() + 1).append(". It exceeds max size ").append(this.pMaxStackSizeValue).append("! Call stack:").append('\n');
            sb.append("\n").append(0).append(": ").append(this.link(method)).append("()");
            int i = 0;
            while (i < methodStack.size()) {
                FunctionCallInfo child = (FunctionCallInfo)methodStack.get(i);
                sb.append("\n").append(i + 1).append(": ").append(this.link(child.getNamedElement())).append("()");
                if (i == 0) {
                    sb.append(" - in ").append(this.link(method)).append(":").append(child.hidOccurence.getLine());
                } else if (i > 0) {
                    FunctionCallInfo prevChild = (FunctionCallInfo)methodStack.get(i - 1);
                    sb.append(" - in ").append(this.link(prevChild.namedElement)).append(":").append(child.hidOccurence.getLine());
                }
                ++i;
            }
            sb.append("\n");
            this.addHit(method, sb.toString());
        }
    }

    private List<FunctionCallInfo> visitMethods(RfNamedElement method, HashMap<RfNamedElement, List<FunctionCallInfo>> map, boolean ignoreForksValue) {
        List<FunctionCallInfo> stack = map.get(method);
        if (stack != null) {
            return stack;
        }
        this.notifyCheckAlive();
        stack = new ArrayList<FunctionCallInfo>();
        map.put(method, stack);
        FunctionCallInfo maxChild = null;
        List<FunctionCallInfo> maxChildStack = null;
        List<FunctionCallInfo> children = this.getAllFunctionCalls(method, ignoreForksValue);
        for (FunctionCallInfo child : children) {
            List<FunctionCallInfo> childStack = this.visitMethods(child.getNamedElement(), map, ignoreForksValue);
            if (maxChildStack != null && (childStack == null || childStack.size() <= maxChildStack.size())) continue;
            maxChild = child;
            maxChildStack = childStack;
        }
        if (maxChildStack != null) {
            stack.add(maxChild);
            stack.addAll(maxChildStack);
        }
        return stack;
    }

    private List<FunctionCallInfo> getAllFunctionCalls(RfNamedElement method, final boolean ignoreForksValue) {
        final ArrayList<FunctionCallInfo> children = new ArrayList<FunctionCallInfo>();
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                String functionFullName;
                if (hid == null || !hid.isMethodCall(false) || !HidUtils.isResolved((IHidObject)hid)) {
                    return true;
                }
                IRfNamedElement element = hid.getElement();
                if (Check_SVTB_12_8.this.pIgnoreCallsToPredefinedMethodsValue && element.isPredefined()) {
                    return true;
                }
                if (LintUtils.isInsideMacroWithPrefix((RfNamedElement)element, Check_SVTB_12_8.this.pIgnoreCallsToMethodsDeclaredInsideMacrosWithPrefixesValue)) {
                    return true;
                }
                if (LintUtils.isInsidePackageWithPrefix((RfNamedElement)element, Check_SVTB_12_8.this.pCallsToMethodsDeclaredInsidePackagesWithPrefixesValue)) {
                    return true;
                }
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (!ignoreForksValue) {
                    if (!(this.holder instanceof RfHidHolder)) {
                        return true;
                    }
                    IRfNamedElement scope = ((RfHidHolder)this.holder).getScope();
                    while (!(scope instanceof RfFunction)) {
                        if (scope instanceof RfActionBlock && ((RfActionBlock)scope).hasForkJoin()) {
                            return true;
                        }
                        scope = scope.getEnclosingScope();
                    }
                }
                if (Check_SVTB_12_8.this.pIgnoreCallsToValue.contains(functionFullName = LintUtils.getNamedElementFullName((RfNamedElement)element))) {
                    return true;
                }
                boolean isExcluded = true;
                HidOccurrence occurence = hid.getOccurrence();
                HidOccurrence backup = null;
                if (occurence == null) {
                    return true;
                }
                if (!LintUtils.isInsideMacroWithPrefix(occurence, Check_SVTB_12_8.this.pIgnoreCallsInsideMacrosWithPrefixesValue)) {
                    isExcluded = false;
                    backup = occurence;
                }
                if (!isExcluded && backup != null) {
                    children.add(new FunctionCallInfo((RfNamedElement)element, backup));
                }
                return true;
            }
        };
        method.visitHidObject(null, visitor);
        return children;
    }

    private static class FunctionCallInfo {
        private RfNamedElement namedElement;
        private HidOccurrence hidOccurence;

        public FunctionCallInfo(RfNamedElement namedElement, HidOccurrence occurence) {
            this.namedElement = namedElement;
            this.hidOccurence = occurence;
        }

        public RfNamedElement getNamedElement() {
            return this.namedElement;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.namedElement == null ? 0 : this.namedElement.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionCallInfo other = (FunctionCallInfo)obj;
            return !(this.namedElement == null ? other.namedElement != null : !this.namedElement.equals(other.namedElement));
        }
    }
}

