/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="16.1.29")
@CheckID(value="SVTB.12.9")
@CheckName(value="SVTB.12.9")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.STYLING, RuleLabel.ARGUMENT})
@CheckTitle(value="Declare methods using ANSI C style arguments")
@CheckDescription(value="Declare methods using ANSI C style arguments.\n\nNot allowed:\n   function logic myfunc;\n      input int x;\n      input int y;\n   endfunction\n\nAllowed:\n   function logic myfunc(int x, int y);\n\nCheck supports pre-waiving.")
public class Check_SVTB_12_9
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true methods without any arguments will not be checked.", name="skipMethodsWithoutArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMethodsWithoutArguments;

    public Check_SVTB_12_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> functions = new NullProtectedList<RfNamedElement>();
        functions.addAll(this.fOVMProject.getAllFunctions());
        functions.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement element : functions) {
            List<IRfFieldElement> arguments;
            RfFunction function;
            if (element == null || !(element instanceof RfFunction) || this.checkPreWaivers(element.getFile()) || (function = (RfFunction)element).isLet() || function.isDPI()) continue;
            this.notifyCheckAlive();
            if (this.pSkipMethodsWithoutArguments && ((arguments = function.getArguments()) == null || arguments.isEmpty())) continue;
            for (RfDefElement def : function.getDeclarations()) {
                if (def == null || !(def instanceof RfFunctionDef) || ((RfFunctionDef)def).isANSIStyle()) continue;
                if (function.isTask()) {
                    this.addHit(def.getParserPath(), def.getStartLine(), "Task '" + LintUtils.getNamedElementFullName(element) + "' is not declared using ANSI C style arguments", def.getReparseInfo());
                    continue;
                }
                this.addHit(def.getParserPath(), def.getStartLine(), "Function '" + LintUtils.getNamedElementFullName(element) + "' is not declared using ANSI C style arguments", def.getReparseInfo());
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

