/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.13.1.1")
@CheckName(value="SVTB.13.1.1")
@CheckLabel(labels={RuleLabel.INTERPROCESS_COMMUNICATION})
@CheckTitle(value="Only Get and Put one key")
@CheckDescription(value="Getting and putting non-unit values of keys can result in a lockup (or starve) condition.\nExample:\nmysem.get(2); //not recommended\nmysem.get(1); //allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_13_1_1
extends OVMComplianceCheck {
    public Check_SVTB_13_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement container : this.fOVMProject.getAllNonXVMFunctionCallContainers()) {
            if (this.checkPreWaivers(container.getFile())) continue;
            List<RfFunctionCall> calls = container.getFunctionCallsWithPrefix("", 2);
            for (RfFunctionCall call : calls) {
                String value;
                String firstArg;
                if (!call.getName().endsWith("put") && !call.getName().endsWith("get")) continue;
                this.notifyCheckAlive();
                RfNamedElement callOf = LintUtils.getCallOfPhysicalType(call);
                if (callOf == null || !(callOf instanceof RfClass) || !((RfClass)callOf).isSubClass("semaphore", true) || (firstArg = call.getArgumentValue(0)) == null || "1".equals(firstArg)) continue;
                RfNamedElement enclosingScope = call.getEnclosingScope();
                RfField candidate = enclosingScope.getParameterWithPrefix(firstArg, 128, 1, 3);
                if (candidate == null) {
                    candidate = enclosingScope.getFieldWithPrefix(firstArg, 1, 3, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (candidate == null) {
                    candidate = enclosingScope.getVarWithPrefix(Integer.MAX_VALUE, firstArg, 1);
                }
                if (candidate != null && (value = candidate.getInitialValue(false)) != null && ("1".equals(value) || (candidate = enclosingScope.getParameterWithPrefix(value, 128, 1, 3)) != null && "1".equals(value = candidate.getInitialValue(false)))) continue;
                this.addHit(call, String.valueOf(call.getFunctionName()) + "() used with non-unit argument");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

