/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.13.1.2")
@CheckName(value="SVTB.13.1.2")
@CheckLabel(labels={RuleLabel.INTERPROCESS_COMMUNICATION, RuleLabel.CLASS, RuleLabel.EXTEND})
@CheckTitle(value="Do not extend the semaphore class")
@CheckDescription(value="Not allowed:\nclass my_semaphore extends semaphore;")
public class Check_SVTB_13_1_2
extends OVMComplianceCheck {
    public Check_SVTB_13_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement classs : this.fOVMProject.getAllNonXVMClasses()) {
            if (!((RfClass)classs).isSubClass("semaphore", true)) continue;
            this.addHit(classs, "User defined class '" + classs.getName() + "' extends semaphore!");
        }
    }
}

