/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.30")
@CheckID(value="SVTB.13.2.1")
@CheckName(value="SVTB.13.2.1")
@CheckLabel(labels={RuleLabel.INTERPROCESS_COMMUNICATION, RuleLabel.EVENT_CONTROL, RuleLabel.WAIT})
@CheckTitle(value="Use wait event.triggered instead of @event")
@CheckDescription(value="Using @ to wait for an event can lead to deadlock or race conditions because the event's triggered state persists throughout the time step until simulation time advances. Avoid this by using wait triggered.\nExamples\nmodule test_module;\n\tevent clk_ev;\n\n\talways @(clk_ev) begin // not allowed\n\t\t$display(\"ClockEvent\");\n\tend\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_13_2_1
extends OVMComplianceCheck {
    public Check_SVTB_13_2_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_EVENT_CONTROL}){

            public boolean visitHit(HidOperator operator, IRfNamedElement scope) {
                IHidObject lhValue = operator.getLHValue();
                if (HidUtils.isOperator((IHidObject)lhValue) && ((IHidOperator)lhValue).isRepeat()) {
                    lhValue = ((IHidOperator)lhValue).getFirstRHValue();
                }
                if (lhValue == null || !(lhValue instanceof RfHid) && !(lhValue instanceof RfHidOperator)) {
                    return true;
                }
                Check_SVTB_13_2_1.this.notifyCheckAlive();
                if (Check_SVTB_13_2_1.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (lhValue instanceof RfHid) {
                    this.checkHid((RfHid)lhValue);
                } else if (lhValue instanceof RfHidOperator) {
                    this.checkOperator((RfHidOperator)lhValue);
                }
                return true;
            }

            private void checkHid(RfHid hid) {
                IRfNamedElement element = hid.getElement();
                if (element instanceof RfField && ((RfField)element).isEvent()) {
                    Check_SVTB_13_2_1.this.addHit(this.parserPath, hid, "@ is used to wait for event '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "'!");
                }
            }

            private void checkOperator(RfHidOperator operator) {
                List rhValues;
                ArrayList<IHidObject> values = new ArrayList<IHidObject>();
                IHidObject lhValue = operator.getLHValue();
                if (lhValue != null) {
                    values.add(lhValue);
                }
                if ((rhValues = OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false)) != null && !rhValues.isEmpty()) {
                    values.addAll(rhValues);
                }
                for (IHidObject value : values) {
                    if (value instanceof RfHid) {
                        this.checkHid((RfHid)value);
                        continue;
                    }
                    if (!(value instanceof RfHidOperator)) continue;
                    this.checkOperator((RfHidOperator)value);
                }
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)hidOperatorVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

