/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.13.3")
@CheckName(value="SVTB.13.3")
@CheckLabel(labels={RuleLabel.INTERPROCESS_COMMUNICATION})
@CheckTitle(value="Not Allowed: Mailbox")
@CheckDescription(value="The selected methodology offers a mechanism for IPC data transfer that wraps the mailbox type. Use the selected metodology's construct.\nXVM -> tlm_fifo, tlm_analysis_fifo")
public class Check_SVTB_13_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Skip classes that inherit from a class that has a name matching skipBaseClassPattern.", name="skipBaseClassPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pSkipBaseClassPattern;
    @CheckParameter(defaultValue="false", description="When true, allow use of mailbox in modules", name="allowMailBoxInModules", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowMailBoxInModules;

    public Check_SVTB_13_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (Check_SVTB_13_3.this.pSkipBaseClassPattern != null && !Check_SVTB_13_3.this.pSkipBaseClassPattern.pattern().isEmpty() && namedElement instanceof RfClass) {
                    RfClass parent = (RfClass)namedElement;
                    while (parent != null) {
                        if (Check_SVTB_13_3.this.pSkipBaseClassPattern.matcher(parent.getFullName()).matches()) {
                            return false;
                        }
                        parent = parent.getParent();
                    }
                }
                if (Check_SVTB_13_3.this.pAllowMailBoxInModules && namedElement instanceof RfModule) {
                    return false;
                }
                if (namedElement instanceof RfAssociatedType) {
                    RfNamedElement dataType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)namedElement);
                    Check_SVTB_13_3.this.notifyCheckAlive();
                    if (dataType != null && dataType.getName().equals("mailbox")) {
                        RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                        Check_SVTB_13_3.this.addHit(namedElement, "'mailbox' is used" + (enclosingScope == null ? "" : " in '" + LintUtils.getNamedElementFullName(enclosingScope) + "'"));
                    }
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().accept(visitor);
    }
}

