/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.1")
@CheckName(value="SVTB.14.10.1")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.CLOCK, RuleLabel.EVENT_CONTROL, RuleLabel.CONSTANT})
@CheckTitle(value="Do not use constant clocks in assertions")
@CheckDescription(value="Do not use constant clocks in assertions.\nExample:\nparameter ALWAYS_ON = 1;\nconst int CONST_CLK;\nassert property (@(ALWAYS_ON) (a || b) ); //not allowed\nassert property (@(1) (a || b) ); //not allowed\nassert property (@(CONST_CLK) (a || b) ); //not allowed")
public class Check_SVTB_14_10_1
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();

    public Check_SVTB_14_10_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.performCheckOnAllClockingEvents(this.fOVMProject, numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    public void checkClockingEvents(List<IHidOperator> clockingEvents, RfNamedElement assertionPropSeq) {
        if (clockingEvents == null) {
            return;
        }
        for (IHidOperator clockingEvent : clockingEvents) {
            Set hids = HidUtils.flattenToHids((IHidObject)clockingEvent, (Set)HidFlatteningOption.NONE_EXCLUDED);
            for (IHid iHid : hids) {
                IRfNamedElement element;
                if (iHid instanceof RfHidImplicit) {
                    this.addHit(assertionPropSeq, "Constant clock '" + iHid + "' is used in " + assertionPropSeq.getSignature());
                }
                if (!(iHid instanceof RfHid) || !((element = ((RfHid)iHid).getElement()) instanceof RfField) || !((RfField)element).isParameter() && !((RfElement)element).isConst()) continue;
                this.addHit(assertionPropSeq, "Constant clock '" + element.elementPathName() + "' is used in " + assertionPropSeq.getSignature());
            }
        }
    }
}

