/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.10")
@CheckName(value="SVTB.14.10.10")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.SIGNAL, RuleLabel.ARGUMENT, RuleLabel.PERFORMANCE, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Group signals before using them as arguments for sampled value functions")
@CheckDescription(value="Sampled value functions impose a performance overhead. Reducing the number of calls by grouping the signals can improve the performance.\nExample:\n$past(a) && $past(b) // not allowed\n$past(a && b) // allowed")
public class Check_SVTB_14_10_10
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    private static final List<String> SAMPELED_VALUE_FUNCTIONS_EXPRESSIONS = Arrays.asList("($fell(_A_) && $fell(_B_))", "($past(_A_) && $past(_B_))", "($stable(_A_) && $stable(_B_))", "($rose(_A_) && $rose(_B_))", "($sampled(_A_) && $sampled(_B_))", "($changed(_A_) && $changed(_B_))");

    public Check_SVTB_14_10_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "Not grouped together expressions for sampled value function ''{0}'' found on ''{1}''! Use ''$sampled_valued_function(A && B)'' instead.";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(SAMPELED_VALUE_FUNCTIONS_EXPRESSIONS), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }
}

