/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.11")
@CheckName(value="SVTB.14.10.11")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.SIGNAL, RuleLabel.ARGUMENT, RuleLabel.PERFORMANCE, RuleLabel.CONCATENATION, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Concatenate signals before using them as arguments for $isunknown()")
@CheckDescription(value="Do not use '$isunknown(A) | $isunknown(B)' or '$isunknown(A | B)', use instead a faster equivalent '$isunknown({A, B})'.\n\nExamples\nassert1: assert property (($isunknown(A | B) or $isunknown(A) | $isunknown(B))); // not allowed\nassert2: assert property (($isunknown({A, B})));  // allowed\n")
public class Check_SVTB_14_10_11
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();

    public Check_SVTB_14_10_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "Forbidden pattern ''{0}'' found on ''{1}''! Use ''$isunknown( '{ A, B '} )'' instead.";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("($isunknown(_ANY_) | $isunknown(_ANY_))", "($isunknown(_ANY_ | _ANY_))")), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }
}

