/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.12")
@CheckName(value="SVTB.14.10.12")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.RANGE, RuleLabel.PERFORMANCE})
@CheckTitle(value="Do not use unbounded ranges in concurrent assertions")
@CheckDescription(value="Do not use unbounded ranges in concurrent assertions. They can cause severe simulation performance problems from launching a new checking thread every cycle and should be used with extreme caution.\nExample:\n##[0 : $], ##[1 : $] // not allowed\n##[*], ##[+] // not allowed \n[-> 1 : $] // not allowed\n[= 1 : $] // not allowed")
public class Check_SVTB_14_10_12
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    private static final List<String> UNBOUND_RANGES_EXPRESSIONS = Arrays.asList("(_A_ ##[_B_ : $] _C_)", "(##[_A_ : $] _B_)", "(_A_ ##[*] _B_)", "(_A_ ##[+] _B_)", "(_A_[* _B_ : $])", "(_A_[-> _B_ : $])", "(_A_[= _B_ : $])");

    public Check_SVTB_14_10_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "Forbidden unbound range ''{0}'' found on ''{1}''!";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(UNBOUND_RANGES_EXPRESSIONS), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }
}

