/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.13")
@CheckName(value="SVTB.14.10.13")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use negated implication in concurrent assertions")
@CheckDescription(value="Do not use negated implication in concurrent assertions.\n'(not (a |-> b))' is equivalent with '(a && !b)' and it means 'a' must be true every cycle and must always result in '!b'.\nIn most cases the intention is that if 'a' occurs it always results in '!b'.\n\nExamples\nassert1: assert property (not (a |-> b)); // not allowed\nassert2: assert property ((a && !b));  // allowed\n")
public class Check_SVTB_14_10_13
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    private static final List<String> NEGATED_IMPLICATION_EXPRESSIONS = Arrays.asList("(not (_ANY_ |-> _ANY_))", "(not (_ANY_ |=> _ANY_))");

    public Check_SVTB_14_10_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "Forbidden negated implication found on ''{1}''.";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(NEGATED_IMPLICATION_EXPRESSIONS), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }
}

