/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.14")
@CheckName(value="SVTB.14.10.14")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use implications in cover properties")
@CheckDescription(value="Do not use implications in cover properties.\nThe implication operators are commonly used to define assertions stating that an antecedent implies a consequent. The result of the implication is either true or false.\nA common mistake is to use the implication in a cover property expression when the intent is to cover the case when the antecedent is true and the consequent follows.\nHowever, with these operators, if there is no match of the antecedent, the implication evaluation returns true by definition, creating a coverage report that is not useful.\n\nExample:\ncover property(valid |=> ready) // not allowed \ncover property(valid ##1 ready) // allowed")
public class Check_SVTB_14_10_14
extends AbstractSVAPatternDetector {
    private static final List<String> IMPLICATION_EXPRESSIONS = Arrays.asList("(_ANY_ |-> _ANY_)", "(_ANY_ |=> _ANY_)");
    private static final List<String> ASSERTION_KIND = Arrays.asList("concurrent_cover_property");

    public Check_SVTB_14_10_14(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "Forbidden implication found in cover property ''{1}''.";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(new HashSet<String>(ASSERTION_KIND));
        this.detectPattern(this.fOVMProject, new HashSet<String>(IMPLICATION_EXPRESSIONS), pFailureMessageFormatValue, numericalAssertKind, Collections.emptySet());
    }
}

