/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.11")
@CheckID(value="SVTB.14.10.15")
@CheckName(value="SVTB.14.10.15")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.EVENT_CONTROL, RuleLabel.EDGE})
@CheckTitle(value="Edge must be specified for all clocking event expressions of a property")
@CheckDescription(value="Edge must be specified for all clocking event expressions of a property.\nExample:\nassert property (@(clk) (...) ); // not allowed\nassert property (@(posedge clk) (...) ); // allowed")
public class Check_SVTB_14_10_15
extends AbstractSVAPatternDetector {
    public Check_SVTB_14_10_15(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> pAssertionKindValue = new HashSet<String>(Arrays.asList("concurrent_assert", "concurrent_assume", "concurrent_cover_property", "expect", "restrict", "property"));
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(pAssertionKindValue);
        this.performCheckOnAllClockingEvents(this.fOVMProject, numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    public void checkClockingEvents(List<IHidOperator> clockingEvents, RfNamedElement assertionPropSeq) {
        if (clockingEvents == null) {
            return;
        }
        for (IHidOperator clockingEvent : clockingEvents) {
            IHidObject lhValue = clockingEvent.getLHValue();
            if (!(lhValue instanceof RfHidOperator) && !(lhValue instanceof RfHid)) continue;
            this.checkEventExpressions(lhValue, assertionPropSeq);
        }
    }

    private void checkEventExpressions(IHidObject root, RfNamedElement assertionPropSeq) {
        if (root == null) {
            return;
        }
        if (root instanceof RfHidOperator) {
            RfHidOperator hidOperator = (RfHidOperator)root;
            if (hidOperator.isEventControlOR() || hidOperator.isComma()) {
                ListContainer eventExpressions = hidOperator.getRHValues();
                for (IHidObject eventExpression : eventExpressions) {
                    this.checkEventExpressions(eventExpression, assertionPropSeq);
                }
                return;
            }
            if (hidOperator.isAnyEdgeEvent()) {
                return;
            }
            if (hidOperator.isIffExpression()) {
                this.checkEventExpressions(hidOperator.getLHValue(), assertionPropSeq);
                return;
            }
            this.addHit(assertionPropSeq, "Clocking event expression '" + HidUtils.toNiceString((IHidObject)root) + "' doesn't have the edge specified!");
            return;
        }
        if (root instanceof RfHid && ((RfHid)root).getElement() instanceof RfPropertySequence) {
            return;
        }
        this.addHit(assertionPropSeq, "Clocking event expression '" + HidUtils.toNiceString((IHidObject)root) + "' doesn't have the edge specified!");
    }
}

