/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="18.1.11")
@CheckID(value="SVTB.14.10.16")
@CheckName(value="SVTB.14.10.16")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.SEQUENCE, RuleLabel.EVENT_CONTROL})
@CheckTitle(value="Do not use sequences in clocking events of a property")
@CheckDescription(value="Do not use sequences in clocking events of a property.\n\nExample:\nmodule top;\n\twire a = 1, b = 1;\n\treg clk = 0;\n\tsequence test_sequence_1;\n\t\t@(posedge clk)  a ##2 b;\n\tendsequence\n\n\tassert_1_1: assert property ( @a  (a || b) ); // allowed\n\tassert_1_2: assert property ( @test_sequence_1  (a || b) ); // not allowed\nendmodel")
public class Check_SVTB_14_10_16
extends AbstractSVAPatternDetector {
    private static final Set<HidFlatteningOption> ONLY_HIDS_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS);

    public Check_SVTB_14_10_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> pAssertionKindValue = new HashSet<String>(Arrays.asList("concurrent_assert", "concurrent_assume", "concurrent_cover_property", "expect", "property", "restrict"));
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(pAssertionKindValue);
        this.performCheckOnAllClockingEvents(this.fOVMProject, numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    public void checkClockingEvents(List<IHidOperator> clockingEvents, RfNamedElement assertionPropSeq) {
        if (clockingEvents == null) {
            return;
        }
        for (IHidOperator clockingEvent : clockingEvents) {
            Set hids = HidUtils.flattenToHids((IHidObject)clockingEvent, ONLY_HIDS_FLATTENING);
            for (IHid iHid : hids) {
                IRfNamedElement element;
                if (!(iHid instanceof RfHid) || !((element = ((RfHid)iHid).getElement()) instanceof RfPropertySequence) || !((RfPropertySequence)element).isSequence()) continue;
                this.addHit(assertionPropSeq, "Sequence '" + HidUtils.toNiceString((IHidObject)iHid) + "' used in clocking event of a property!");
            }
        }
    }
}

