/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.11")
@CheckID(value="SVTB.14.10.17")
@CheckName(value="SVTB.14.10.17")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.OPERATOR})
@CheckTitle(value="Do not mix |-> and |=> in the same assertion")
@CheckDescription(value="Do not mix overlapping |-> and nonoverlapping |=> implications in the same assertion.\n\nExamples\nassert1: assert property ((A |-> (B |=> $past(C)))); // not allowed\nassert2: assert property ((A |=> (B |=> $past(C))));  // allowed\n")
public class Check_SVTB_14_10_17
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();

    public Check_SVTB_14_10_17(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("(_ANY_)")), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, RfNamedElement assertion) {
        final ArrayList dashImplications = new ArrayList();
        final ArrayList equalImplications = new ArrayList();
        Predicate<IHidObject> cons = new Predicate<IHidObject>(){

            @Override
            public boolean test(IHidObject element) {
                if (element instanceof RfHidOperator) {
                    if (((RfHidOperator)element).isDashImplication()) {
                        dashImplications.add((RfHidOperator)element);
                    }
                    if (((RfHidOperator)element).isEqualImplication()) {
                        equalImplications.add((RfHidOperator)element);
                    }
                }
                return true;
            }
        };
        HidUtils.flattenToObjects((Predicate)cons, (IHidObject)expression, (Set)HidFlatteningOption.NONE_EXCLUDED);
        if (!dashImplications.isEmpty() && !equalImplications.isEmpty()) {
            this.addHit(assertion, "'|->' and '|=>' used in the same assertion: '" + HidUtils.toNiceString((IHidObject)expression) + " '!");
        }
        return false;
    }
}

